/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.hie;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hie.HieProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class IceBlockPheasantProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE);

    public IceBlockPheasantProjectile(World world) {
        super(HieProjectiles.ICE_BLOCK_PHEASANT, world);
    }

    public IceBlockPheasantProjectile(EntityType type, World world) {
        super(type, world);
    }

    public IceBlockPheasantProjectile(World world, double x, double y, double z) {
        super(HieProjectiles.ICE_BLOCK_PHEASANT, world, x, y, z);
    }

    public IceBlockPheasantProjectile(World world, LivingEntity player) {
        super(HieProjectiles.ICE_BLOCK_PHEASANT, world, player);
        this.setDamage(45.0f);
        this.setArmorPiercing();
        this.setPassThroughEntities();
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.setMaxLife(60);
        this.onTickEvent = this::onTickEvent;
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(ModEffects.FROZEN, 300, 0)};
    }

    private void onTickEvent() {
        BlockPos pos = null;
        int j = 1;
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177979_c(j));
            if (state.func_200132_m()) {
                pos = this.func_180425_c().func_177979_c(j);
                break;
            }
            if (j > 2) break;
            ++j;
        }
        if (pos == null) {
            return;
        }
        int size = 2 + 4 * (this.getMaxLife() - this.getLife()) / this.getMaxLife();
        AbilityHelper.createFilledSphere(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), size, Blocks.field_205164_gk, GRIEF_RULE);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = WyHelper.randomDouble();
                double offsetY = WyHelper.randomDouble();
                double offsetZ = WyHelper.randomDouble();
                GenericParticleData data = new GenericParticleData(ModParticleTypes.HIE);
                data.setLife(8);
                data.setSize(2.0f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

