/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.mera;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.MeraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class HidarumaProjectile
extends AbilityProjectileEntity {
    private Optional<LivingEntity> target;

    public HidarumaProjectile(World world) {
        super(MeraProjectiles.HIDARUMA, world);
    }

    public HidarumaProjectile(EntityType type, World world) {
        super(type, world);
    }

    public HidarumaProjectile(World world, double x, double y, double z) {
        super(MeraProjectiles.HIDARUMA, world, x, y, z);
    }

    public HidarumaProjectile(World world, LivingEntity player) {
        super(MeraProjectiles.HIDARUMA, world, player);
        this.setDamage(3.5f);
        this.setMaxLife(120);
        this.setGravity(0.0f);
        this.setDamageSource(ModDamageSource.FIRE.causeIndirectDamageFromSource(this));
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        SetOnFireEvent event = new SetOnFireEvent(this.func_85052_h(), hitEntity, 3);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            hitEntity.func_70015_d(3);
        }
        this.func_70106_y();
    }

    public void setTarget(Optional<LivingEntity> target) {
        this.target = target;
    }

    private void onTickEvent() {
        if (this.target == null || !this.target.isPresent() || !this.target.get().func_70089_S()) {
            List list = WyHelper.getEntitiesNear(this.func_180425_c(), this.field_70170_p, 16.0, this.func_85052_h() instanceof PlayerEntity ? FactionHelper.getOutsideGroupPredicate((LivingEntity)((PlayerEntity)this.func_85052_h())) : EntityPredicates.field_180132_d, LivingEntity.class);
            list.remove(this.func_85052_h());
            list.sort(MobsHelper.ENTITY_THREAT);
            if (list.size() > 0) {
                this.target = list.stream().findAny();
            }
        } else {
            Vec3d dist = this.func_213303_ch().func_178788_d(this.target.get().func_213303_ch()).func_72441_c(0.0, -1.0, 0.0);
            double speedReduction = 12.0;
            double speed = 0.5;
            double xSpeed = Math.min(speed, -dist.field_72450_a / speedReduction);
            double ySpeed = Math.min(speed, -dist.field_72448_b / speedReduction);
            double zSpeed = Math.min(speed, -dist.field_72449_c / speedReduction);
            this.func_213293_j(xSpeed, ySpeed, zSpeed);
            this.field_70133_I = true;
        }
        if (this.func_208600_a(FluidTags.field_206959_a)) {
            this.func_70106_y();
            this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 1.1, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197632_y, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

