/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.mera;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.MeraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class HiganProjectile
extends AbilityProjectileEntity {
    public HiganProjectile(World world) {
        super(MeraProjectiles.HIGAN, world);
    }

    public HiganProjectile(EntityType type, World world) {
        super(type, world);
    }

    public HiganProjectile(World world, double x, double y, double z) {
        super(MeraProjectiles.HIGAN, world, x, y, z);
    }

    public HiganProjectile(World world, LivingEntity player) {
        super(MeraProjectiles.HIGAN, world, player);
        this.setDamage(4.0f);
        this.setDamageSource(ModDamageSource.FIRE.causeIndirectDamageFromSource(this));
        this.setChangeHurtTime(true);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        SetOnFireEvent event = new SetOnFireEvent(this.func_85052_h(), hitEntity, 4);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            hitEntity.func_70015_d(4);
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.placeBlockIfAllowed(this.field_70170_p, hit.func_177958_n(), hit.func_177956_o() + 1, hit.func_177952_p(), Blocks.field_150480_ab, AirBlockProtectionRule.INSTANCE);
    }

    private void onTickEvent() {
        if (this.func_208600_a(FluidTags.field_206959_a)) {
            this.func_70106_y();
            this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 1.1, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 5.0;
                double offsetY = WyHelper.randomDouble() / 5.0;
                double offsetZ = WyHelper.randomDouble() / 5.0;
                GenericParticleData data = new GenericParticleData(ModParticleTypes.MERA);
                data.setLife(10);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 0.25 + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

