/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.moku;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.entities.projectiles.moku.MokuProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class WhiteBlowProjectile
extends AbilityProjectileEntity {
    public WhiteBlowProjectile(World world) {
        super(MokuProjectiles.WHITE_BLOW, world);
    }

    public WhiteBlowProjectile(EntityType type, World world) {
        super(type, world);
    }

    public WhiteBlowProjectile(World world, double x, double y, double z) {
        super(MokuProjectiles.WHITE_BLOW, world, x, y, z);
    }

    public WhiteBlowProjectile(World world, LivingEntity player) {
        super(MokuProjectiles.WHITE_BLOW, world, player);
        this.setDamage(2.0f);
        this.setMaxLife(24);
        this.setChangeHurtTime(true);
        this.setPhysical(true);
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(ModEffects.SMOKE, 200, 0)};
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                GenericParticleData data = new GenericParticleData(ModParticleTypes.MOKU);
                data.setLife(10);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

