/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.moku;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.entities.projectiles.moku.MokuProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class WhiteOutProjectile
extends AbilityProjectileEntity {
    public WhiteOutProjectile(World world) {
        super(MokuProjectiles.WHITE_OUT, world);
    }

    public WhiteOutProjectile(EntityType type, World world) {
        super(type, world);
    }

    public WhiteOutProjectile(World world, double x, double y, double z) {
        super(MokuProjectiles.WHITE_OUT, world, x, y, z);
    }

    public WhiteOutProjectile(World world, LivingEntity player) {
        super(MokuProjectiles.WHITE_OUT, world, player);
        this.setDamage(10.0f);
        this.setMaxLife(128);
        this.setPhysical(true);
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(ModEffects.SMOKE, 500, 0)};
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                GenericParticleData data = new GenericParticleData(ModParticleTypes.MOKU);
                data.setLife(10);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

