/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu.NikyuProjectiles;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class PadHoProjectile
extends AbilityProjectileEntity {
    public PadHoProjectile(World world) {
        super(NikyuProjectiles.PAD_HO, world);
    }

    public PadHoProjectile(EntityType type, World world) {
        super(type, world);
    }

    public PadHoProjectile(World world, double x, double y, double z) {
        super(NikyuProjectiles.PAD_HO, world, x, y, z);
    }

    public PadHoProjectile(World world, LivingEntity player) {
        super(NikyuProjectiles.PAD_HO, world, player);
        this.setDamage(10.0f);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
    }

    private void onEntityImpactEvent(LivingEntity target) {
        this.onBlockImpactEvent.onImpact(target.func_180425_c());
        Vec3d speed = target.func_70676_i(1.0f).func_216372_d(-1.0, -1.0, -1.0).func_216372_d(WyHelper.randomWithRange(4, 6), WyHelper.randomWithRange(1, 3), WyHelper.randomWithRange(4, 6));
        target.func_213293_j(speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        target.field_70133_I = true;
        target.field_70143_R = 0.0f;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), this.getDamage() / 5.0f);
        explosion.setStaticDamage(5.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }
}

