/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu.NikyuProjectiles;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.IFlexibleSizeProjectile;

public class UrsusShockProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    public float multiplier = 0.0f;

    public UrsusShockProjectile(World world) {
        super(NikyuProjectiles.URSUS_SHOCK, world);
    }

    public UrsusShockProjectile(EntityType type, World world) {
        super(type, world);
    }

    public UrsusShockProjectile(World world, double x, double y, double z) {
        super(NikyuProjectiles.URSUS_SHOCK, world, x, y, z);
    }

    public UrsusShockProjectile(World world, LivingEntity player) {
        super(NikyuProjectiles.URSUS_SHOCK, world, player);
        this.setDamage(100.0f);
        this.setMaxLife(200);
        this.setArmorPiercing();
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 4.0f + 10.0f * this.multiplier);
        explosion.setStaticDamage(40.0f + 10.0f * this.multiplier);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect((int)(14.0f * this.multiplier)));
        explosion.setDamageEntities(true);
        explosion.doExplosion();
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void increaseSize() {
    }

    @Override
    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
    }

    @Override
    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }
}

