/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.pero;

import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.pero.PeroProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.pero.CandyWaveParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class CandyWaveProjectile
extends AbilityProjectileEntity {
    private static final ParticleEffect PARTICLES = new CandyWaveParticleEffect();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(CoreBlockProtectionRule.INSTANCE);

    public CandyWaveProjectile(World world) {
        super(PeroProjectiles.CANDY_WAVE, world);
    }

    public CandyWaveProjectile(EntityType type, World world) {
        super(type, world);
    }

    public CandyWaveProjectile(World world, double x, double y, double z) {
        super(PeroProjectiles.CANDY_WAVE, world, x, y, z);
    }

    public CandyWaveProjectile(World world, LivingEntity player) {
        super(PeroProjectiles.CANDY_WAVE, world, player);
        this.setDamage(24.0f);
        this.setMaxLife(12);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.setPassThroughEntities();
        this.setPassThroughBlocks();
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(ModEffects.CANDY_STUCK, 100, 0, false, false, false)};
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        BlockPos pos = null;
        int j = 1;
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177979_c(j));
            if (state.func_200132_m()) {
                pos = this.func_180425_c().func_177979_c(j);
                break;
            }
            if (j > 3) break;
            ++j;
        }
        if (pos == null) {
            return;
        }
        int size = 2 + 4 * (this.getMaxLife() - this.getLife()) / this.getMaxLife();
        AbilityHelper.createFilledSphere(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), size, ModBlocks.CANDY, GRIEF_RULE);
        PARTICLES.spawn(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0, 0.0, 0.0);
    }
}

