/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.suna;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.suna.DesertEncierroAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suna.SunaProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class BarjanProjectile
extends AbilityProjectileEntity {
    public BarjanProjectile(World world) {
        super(SunaProjectiles.BARJAN, world);
    }

    public BarjanProjectile(EntityType type, World world) {
        super(type, world);
    }

    public BarjanProjectile(World world, double x, double y, double z) {
        super(SunaProjectiles.BARJAN, world, x, y, z);
    }

    public BarjanProjectile(World world, LivingEntity player) {
        super(SunaProjectiles.BARJAN, world, player);
        this.setDamage(30.0f);
        this.setMaxLife(15);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.setCanGetStuckInGround();
        this.setPassThroughEntities();
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(Effects.field_82731_v, 100, 3, false, false), new EffectInstance(Effects.field_76438_s, 150, 4, false, false), new EffectInstance(Effects.field_76437_t, 150, 0, false, false), new EffectInstance(Effects.field_76421_d, 150, 0, false, false), new EffectInstance(Effects.field_76419_f, 150, 0, false, false)};
        this.onEntityImpactEvent = this::onEntityImpact;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpact(LivingEntity entity) {
        DesertEncierroAbility.drainLiquids(entity, (int)WyHelper.randomWithRange(0, 2), (int)WyHelper.randomWithRange(1, 3), (int)WyHelper.randomWithRange(1, 3));
    }

    private void onTickEvent() {
        for (int i = 0; i < 5; ++i) {
            double offsetX = WyHelper.randomDouble();
            double offsetY = WyHelper.randomDouble() / 4.0;
            double offsetZ = WyHelper.randomDouble();
            GenericParticleData data = new GenericParticleData(ModParticleTypes.SUNA2);
            data.setLife(4);
            data.setSize(1.4f);
            WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
        }
    }
}

