/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.suna;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suna.SunaProjectiles;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.suna.DesertSpadaParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class DesertSpadaProjectile
extends AbilityProjectileEntity {
    private static final ParticleEffect PARTICLES = new DesertSpadaParticleEffect();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(CoreBlockProtectionRule.INSTANCE);

    public DesertSpadaProjectile(World world) {
        super(SunaProjectiles.DESERT_SPADA, world);
    }

    public DesertSpadaProjectile(EntityType type, World world) {
        super(type, world);
    }

    public DesertSpadaProjectile(World world, double x, double y, double z) {
        super(SunaProjectiles.DESERT_SPADA, world, x, y, z);
    }

    public DesertSpadaProjectile(World world, LivingEntity player) {
        super(SunaProjectiles.DESERT_SPADA, world, player);
        this.setDamage(30.0f);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.setMaxLife(45);
        this.setPassThroughEntities();
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(Effects.field_76438_s, 200, 1)};
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        BlockPos pos = null;
        int j = 1;
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177979_c(j));
            if (state.func_200132_m()) {
                pos = this.func_180425_c().func_177979_c(j);
                break;
            }
            if (j > 5) break;
            ++j;
        }
        if (pos == null) {
            return;
        }
        int a = 0;
        int b = 0;
        Direction facingDirection = Direction.func_196054_a((Entity)this)[0];
        if (facingDirection == Direction.NORTH || facingDirection == Direction.SOUTH) {
            a = 1;
        }
        if (facingDirection == Direction.EAST || facingDirection == Direction.WEST) {
            b = 1;
        }
        AbilityHelper.createFilledCube(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), b, 3, a, Blocks.field_150350_a, GRIEF_RULE);
        PARTICLES.spawn(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
    }
}

