/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.suna;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suna.SunaProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class SablesPesadoProjectile
extends AbilityProjectileEntity {
    public SablesPesadoProjectile(World world) {
        super(SunaProjectiles.SABLES_PESADO, world);
    }

    public SablesPesadoProjectile(EntityType type, World world) {
        super(type, world);
    }

    public SablesPesadoProjectile(World world, double x, double y, double z) {
        super(SunaProjectiles.SABLES_PESADO, world, x, y, z);
    }

    public SablesPesadoProjectile(World world, LivingEntity player) {
        super(SunaProjectiles.SABLES_PESADO, world, player);
        this.setDamage(50.0f);
        this.setMaxLife(50);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.setArmorPiercing();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 6.0f);
        explosion.setStaticDamage(35.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(7));
        explosion.setDamageEntities(true);
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            GenericParticleData data;
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            for (i = 0; i < 20; ++i) {
                offsetX = WyHelper.randomDouble();
                offsetY = WyHelper.randomDouble();
                offsetZ = WyHelper.randomDouble();
                data = new GenericParticleData(ModParticleTypes.SUNA);
                data.setLife(6);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
            for (i = 0; i < 2; ++i) {
                offsetX = WyHelper.randomDouble();
                offsetY = WyHelper.randomDouble();
                offsetZ = WyHelper.randomDouble();
                data = new GenericParticleData(ModParticleTypes.SUNA2);
                data.setLife(4);
                data.setSize(1.2f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

