/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.suna;

import java.util.ArrayList;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suna.SunaProjectiles;
import xyz.pixelatedw.mineminenomi.particles.effects.suna.SablesParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.ProjectileShootEvent;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class SablesProjectile
extends AbilityProjectileEntity {
    public Vec3d firstVector = null;
    public Vec3d vector = null;
    boolean shoot = false;
    public float mult = 1.0f;
    private static final SablesParticleEffect PARTICLES = new SablesParticleEffect();

    public SablesProjectile(World world) {
        super(SunaProjectiles.SABLES, world);
    }

    public SablesProjectile(EntityType type, World world) {
        super(type, world);
    }

    public SablesProjectile(World world, double x, double y, double z) {
        super(SunaProjectiles.SABLES, world, x, y, z);
    }

    public SablesProjectile(World world, LivingEntity player) {
        super(SunaProjectiles.SABLES, world, player);
        this.setDamage(0.0f);
        this.setMaxLife(300);
        this.setPhysical(false);
        this.setPassThroughEntities();
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.firstVector == null) {
                this.firstVector = this.func_213303_ch();
            }
            SablesProjectile.PARTICLES.mult = this.mult;
            PARTICLES.spawn(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() - 10.0, this.func_226281_cx_(), this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
            float growthXZ = 4.0f + 6.0f * this.mult;
            float growthY = 10.0f + 12.0f * this.mult;
            ArrayList<FallingBlockEntity> list = new ArrayList<FallingBlockEntity>();
            AxisAlignedBB box = new AxisAlignedBB(new BlockPos(this.func_213303_ch())).func_72314_b((double)growthXZ, (double)growthY, (double)growthXZ);
            for (Entity entity : this.func_85052_h().field_70170_p.func_175647_a(Entity.class, box, e -> e != this.func_85052_h())) {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a + (this.func_226277_ct_() - entity.func_226277_ct_()) / 25.0, entity.func_213322_ci().field_72448_b + (this.func_226278_cu_() - entity.func_226278_cu_()) / 25.0, entity.func_213322_ci().field_72449_c + (this.func_226281_cx_() - entity.func_226281_cx_()) / 25.0);
                if (entity instanceof FallingBlockEntity) {
                    if (!list.contains(entity)) {
                        list.add((FallingBlockEntity)entity);
                    }
                    if (list.size() > 900) {
                        IntStream.range(0, 100).forEach(i -> {
                            ((FallingBlockEntity)list.get(i)).func_213293_j(entity.func_213322_ci().field_72450_a + (this.func_226277_ct_() - entity.func_226277_ct_()), entity.func_213322_ci().field_72448_b + (this.func_226278_cu_() - entity.func_226278_cu_()), entity.func_213322_ci().field_72449_c + (this.func_226281_cx_() - entity.func_226281_cx_()));
                            list.remove(i);
                        });
                    }
                }
                if (!(this.func_70032_d(entity) < 2.0f)) continue;
                entity.func_70097_a(DamageSource.field_188406_j, 10.0f * this.mult);
            }
            box = new AxisAlignedBB(new BlockPos(this.func_213303_ch())).func_72314_b((double)(growthXZ / 2.0f), 15.0, (double)(growthXZ / 2.0f));
            if (CommonConfig.INSTANCE.isAbilityGriefingEnabled()) {
                for (double x = box.field_72340_a; x < box.field_72336_d; x += 1.0) {
                    for (double y = box.field_72338_b; y < box.field_72337_e; y += 1.0) {
                        for (double z = box.field_72339_c; z < box.field_72334_f; z += 1.0) {
                            BlockPos blockPos = new BlockPos(x, y, z);
                            BlockState state = this.field_70170_p.func_180495_p(blockPos);
                            if (state.isAir((IBlockReader)this.field_70170_p, blockPos) || !((double)this.field_70146_Z.nextFloat() > 0.995) || !DefaultProtectionRules.CORE_FOLIAGE_ORE.isPresent(state)) continue;
                            FallingBlockEntity fallingBlock = new FallingBlockEntity(this.field_70170_p, x, y, z, state);
                            fallingBlock.func_213293_j(0.0, WyHelper.randomDouble() / 3.0, 0.0);
                            fallingBlock.field_70133_I = true;
                            fallingBlock.field_145813_c = false;
                            fallingBlock.field_145812_b = 1;
                            this.field_70170_p.func_217376_c((Entity)fallingBlock);
                            this.field_70170_p.func_217377_a(blockPos, false);
                        }
                    }
                }
            }
            if (this.vector != null && !this.shoot) {
                Vec3d dist = this.func_213303_ch().func_178788_d(this.vector).func_72441_c(0.0, -1.0, 0.0);
                double speedReduction = 20.0;
                double speed = 0.4;
                double xSpeed = Math.min(speed, -dist.field_72450_a / speedReduction);
                double ySpeed = Math.min(speed, -dist.field_72448_b / speedReduction);
                double zSpeed = Math.min(speed, -dist.field_72449_c / speedReduction);
                this.func_213293_j(xSpeed, ySpeed, zSpeed);
            }
            if (this.func_70026_G() && this.field_70173_aa % 20 == 0) {
                this.mult = (float)((double)this.mult - 0.1);
                if (0.0f > this.mult) {
                    this.func_70106_y();
                }
            }
        }
    }

    @Override
    public void func_184538_a(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        this.shoot = true;
        ProjectileShootEvent event = new ProjectileShootEvent(this, velocity, inaccuracy);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        Vec3d dist = entityThrower.func_213303_ch().func_72441_c(0.0, (double)entityThrower.func_70047_e(), 0.0).func_178788_d(this.vector).func_72441_c(0.0, -1.0, 0.0);
        double speedReduction = 4.0;
        double xSpeed = -dist.field_72450_a / speedReduction;
        double zSpeed = -dist.field_72449_c / speedReduction;
        this.func_213293_j(MathHelper.func_151237_a((double)xSpeed, (double)-1.0, (double)1.0), 0.0, MathHelper.func_151237_a((double)zSpeed, (double)-1.0, (double)1.0));
    }
}

