/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.blocks.traps.DarknessBlock;
import xyz.pixelatedw.mineminenomi.blocks.traps.TrapAbilityBlock;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.yami.TeleportBlockedEffect;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class BlocksEvents {
    private static final ParticleEffect PARTICLES = new TeleportBlockedEffect();

    @SubscribeEvent
    public static void onEnderTeleport(EnderTeleportEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = event.getEntityLiving().field_70170_p;
        IDevilFruit props = DevilFruitCapability.get(entity);
        if (props.hasDevilFruit(ModAbilities.YAMI_YAMI_NO_MI)) {
            return;
        }
        for (int i = -2; i < 2; ++i) {
            for (int j = -2; j < 2; ++j) {
                for (int k = -2; k < 2; ++k) {
                    BlockPos pos = entity.func_180425_c().func_177982_a(i, j, k);
                    Block b = world.func_180495_p(pos).func_177230_c();
                    if (!(b instanceof DarknessBlock)) continue;
                    event.setCanceled(true);
                    PARTICLES.spawn(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        BlockState belowBlockState = entity.field_70170_p.func_180495_p(new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() + 0.15, entity.func_226281_cx_()));
        if (belowBlockState.func_177230_c() instanceof TrapAbilityBlock) {
            TrapAbilityBlock block = (TrapAbilityBlock)belowBlockState.func_177230_c();
            IDevilFruit props = DevilFruitCapability.get(entity);
            if (props.hasDevilFruit(block.getDevilFruit())) {
                entity.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_());
                entity.field_70143_R = 0.0f;
                entity.field_70122_E = true;
            } else {
                PlayerEntity playerEntity;
                if (entity instanceof PlayerEntity && !(playerEntity = (PlayerEntity)entity).func_184812_l_()) {
                    playerEntity.field_71075_bZ.field_75100_b = false;
                }
                if (block.getPotionEffect() != null && !entity.func_70644_a(block.getPotionEffect().func_188419_a())) {
                    entity.func_195064_c(block.getPotionEffect());
                }
                if (TrapAbilityBlock.isEntityInsideOpaqueBlock(entity, 0)) {
                    entity.func_70097_a(DamageSource.field_76368_d, (float)block.getDamageDealt());
                }
            }
        }
    }
}

