/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

@Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
public class CombatModeEvents {
    private static ArrayList<Effect> potionEffects = new ArrayList<Effect>(Arrays.asList(ModEffects.PARALYSIS, ModEffects.GUARDING, Effects.field_76424_c, Effects.field_76421_d, ModEffects.MOVEMENT_BLOCKED, ModEffects.CANDLE_LOCK));

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderOverlay(RenderGameOverlayEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
        int posX = mc.func_228018_at_().func_198107_o();
        int posY = mc.func_228018_at_().func_198087_p();
        if (abilityDataProps == null) {
            return;
        }
        if (CommonConfig.INSTANCE.isExtraHeartsEnabled()) {
            ++ForgeIngameGui.left_height;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH && CommonConfig.INSTANCE.isExtraHeartsEnabled()) {
            int k;
            int i;
            event.setCanceled(true);
            double maxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
            double health = player.func_110143_aJ();
            int absorptionBonus = MathHelper.func_76123_f((float)player.func_110139_bj());
            int rgb = Color.RED.getRGB();
            if (absorptionBonus > 0) {
                rgb = Color.YELLOW.getRGB();
            }
            WyHelper.drawStringWithBorder(Minecraft.func_71410_x().field_71466_p, (int)(health + (double)absorptionBonus) + "", posX / 2 - 27, posY - 39, rgb);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(Widget.GUI_ICONS_LOCATION);
            for (i = MathHelper.func_76143_f((double)(maxHealth / 2.0)) - 1; i >= 0; --i) {
                k = posX / 2 - 91 + i % 10 * 6;
                GuiUtils.drawTexturedModalRect((int)k, (int)(posY - 39), (int)16, (int)0, (int)9, (int)9, (float)0.0f);
            }
            i = 0;
            while ((double)i < (100.0 - (maxHealth - health) / maxHealth * 100.0) / 10.0) {
                k = posX / 2 - 91 + i % 10 * 6;
                int u = 36;
                if (absorptionBonus > 0) {
                    u = 144;
                }
                GuiUtils.drawTexturedModalRect((int)k, (int)(posY - 39), (int)(16 + u), (int)0, (int)9, (int)9, (float)0.0f);
                ++i;
            }
        }
        if (!entityStatsProps.isInCombatMode()) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            boolean[] visuals = ClientConfig.INSTANCE.getCooldownVisuals();
            boolean hasNumberVisual = visuals[0];
            boolean hasColorVisual = visuals[1];
            event.setCanceled(true);
            RenderSystem.pushMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableLighting();
            RenderSystem.enableBlend();
            WyHelper.drawStringWithBorder(mc.field_71466_p, abilityDataProps.getCombatBarSet() + "", posX / 2 - 110, posY - 14, WyHelper.hexToRGB("#FFFFFF").getRGB());
            mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
            for (int i = 0; i < 8; ++i) {
                boolean isCharging;
                Ability cAbility;
                int j = i + abilityDataProps.getCombatBarSet() * 8;
                Object abl = abilityDataProps.getEquippedAbility(j);
                if (abl == null) {
                    GuiUtils.drawTexturedModalRect((int)((posX - 200 + i * 50) / 2), (int)(posY - 23), (int)0, (int)0, (int)23, (int)23, (float)0.0f);
                    continue;
                }
                String number = "";
                float cooldown = 23.0f - (float)((((Ability)((Object)abl)).getCooldown() - 10.0) / ((Ability)((Object)abl)).getMaxCooldown() * 23.0);
                float threshold = 23.0f;
                float charge = 23.0f;
                if (((Ability)((Object)abl)).isOnCooldown() && ((Ability)((Object)abl)).getCooldown() - 10.0 > 0.0) {
                    number = (int)((Ability)((Object)abl)).getCooldown() - 10 + " ";
                }
                if (abl instanceof ContinuousAbility) {
                    cAbility = (ContinuousAbility)((Object)abl);
                    threshold = (float)((ContinuousAbility)cAbility).getContinueTime() / (float)((ContinuousAbility)cAbility).getThreshold() * 23.0f;
                    if (((ContinuousAbility)cAbility).getThreshold() > 0 && ((Ability)((Object)abl)).isContinuous() && ((ContinuousAbility)cAbility).getContinueTime() > 0) {
                        number = ((ContinuousAbility)cAbility).getThreshold() - ((ContinuousAbility)cAbility).getContinueTime() + " ";
                    }
                }
                if (abl instanceof ChargeableAbility) {
                    cAbility = (ChargeableAbility)((Object)abl);
                    charge = (float)((ChargeableAbility)cAbility).getChargeTime() / (float)((ChargeableAbility)cAbility).getMaxChargeTime() * 23.0f;
                    if (((Ability)((Object)abl)).isCharging() && ((ChargeableAbility)cAbility).getChargeTime() > 0) {
                        number = ((ChargeableAbility)cAbility).getChargeTime() + " ";
                    }
                }
                boolean isContinuous = ((Ability)((Object)abl)).isContinuous() || ((Ability)((Object)abl)).getState() == Ability.State.CONTINUOUS && ((Ability)((Object)abl)).isStateForced();
                boolean bl = isCharging = ((Ability)((Object)abl)).isCharging() || ((Ability)((Object)abl)).getState() == Ability.State.CHARGING && ((Ability)((Object)abl)).isStateForced();
                if (((Ability)((Object)abl)).isOnCooldown() && !((Ability)((Object)abl)).isDisabled() && ((Ability)((Object)abl)).getCooldown() > 10.0) {
                    RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                } else if (isCharging) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                } else if (isContinuous) {
                    RenderSystem.color4f((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                } else if (((Ability)((Object)abl)).isDisabled()) {
                    RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                GuiUtils.drawTexturedModalRect((int)((posX - 200 + i * 50) / 2), (int)(posY - 23), (int)0, (int)0, (int)23, (int)23, (float)0.0f);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (hasColorVisual) {
                    if (((Ability)((Object)abl)).isDisabled()) {
                        RendererHelper.drawAbilityIcon("disabled_status", (posX - 192 + i * 50) / 2, posY - 19, 3, 16, 16);
                        mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
                    } else if (isContinuous) {
                        if (threshold < 2.1474836E9f) {
                            GuiUtils.drawTexturedModalRect((int)((posX - 200 + i * 50) / 2), (int)(posY - 23), (int)24, (int)0, (int)23, (int)((int)threshold), (float)0.0f);
                        }
                    } else if (isCharging) {
                        GuiUtils.drawTexturedModalRect((int)((posX - 200 + i * 50) / 2), (int)(posY - 23), (int)24, (int)0, (int)23, (int)((int)charge), (float)0.0f);
                    } else if (((Ability)((Object)abl)).isOnCooldown() && !((Ability)((Object)abl)).isDisabled() && cooldown < 2.1474836E9f && cooldown > 0.0f) {
                        GuiUtils.drawTexturedModalRect((int)((posX - 200 + i * 50) / 2), (int)(posY - 23), (int)24, (int)0, (int)23, (int)((int)cooldown), (float)0.0f);
                        if (((Ability)((Object)abl)).getCooldown() < 10.0) {
                            RenderSystem.pushMatrix();
                            double scale = 2.5 - ((Ability)((Object)abl)).getCooldown() / 10.0;
                            RenderSystem.color4f((float)0.2f, (float)0.8f, (float)0.4f, (float)((float)(((Ability)((Object)abl)).getCooldown() / 10.0)));
                            RenderSystem.translated((double)((posX - 200 + i * 50) / 2), (double)(posY - 23), (double)1.0);
                            RenderSystem.translated((double)12.0, (double)12.0, (double)0.0);
                            RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
                            RenderSystem.translated((double)-12.0, (double)-12.0, (double)0.0);
                            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)23, (int)23, (float)-1.0f);
                            RenderSystem.popMatrix();
                        }
                    }
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!((Ability)((Object)abl)).isDisabled()) {
                    String texture = ((Ability)((Object)abl)).hasCustomTexture() ? WyHelper.getResourceName(((Ability)((Object)abl)).getCustomTexture()) : WyHelper.getResourceName(((Ability)((Object)abl)).getName());
                    RendererHelper.drawAbilityIcon(texture, (posX - 192 + i * 50) / 2, posY - 19, 16, 16);
                }
                RenderSystem.translated((double)0.0, (double)0.0, (double)2.0);
                if (hasNumberVisual) {
                    WyHelper.drawStringWithBorder(mc.field_71466_p, number, (posX - 172 + i * 50) / 2 - mc.field_71466_p.func_78256_a(number) / 2, posY - 14, WyHelper.hexToRGB("#FFFFFF").getRGB());
                }
                mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
            }
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    public static void onItemPickedUp(EntityItemPickupEvent event) {
        if (ClientConfig.INSTANCE.isCombatPickupOn()) {
            IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)event.getPlayer());
            event.setCanceled(entityStatsProps.isInCombatMode());
        }
    }

    @SubscribeEvent
    public static void updateFOV(FOVUpdateEvent event) {
        if (ClientConfig.INSTANCE.isFOVRemoved()) {
            if (potionEffects.stream().anyMatch(f -> event.getEntity().func_70644_a(f))) {
                event.setNewfov(1.0f);
            }
            if (event.getEntity().func_70644_a(Effects.field_76424_c) && event.getEntity().func_70051_ag()) {
                event.setNewfov(1.1f);
            }
        }
    }
}

