/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.SpecialFlyAbility;
import xyz.pixelatedw.mineminenomi.api.events.BountyEvent;
import xyz.pixelatedw.mineminenomi.api.events.DorikiEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.zoan.YomiZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class ConfigEvents {
    @SubscribeEvent
    public static void onClonePlayer(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            IDevilFruit oldDevilFruitProps = DevilFruitCapability.get((LivingEntity)event.getOriginal());
            IDevilFruit newDevilFruitProps = DevilFruitCapability.get((LivingEntity)event.getPlayer());
            IAbilityData newAbilityData = AbilityDataCapability.get((LivingEntity)event.getPlayer());
            CompoundNBT nbt = new CompoundNBT();
            if (oldDevilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) && !YomiZoanInfo.INSTANCE.isActive((LivingEntity)event.getOriginal())) {
                ConfigEvents.restoreFullData(event.getOriginal(), event.getPlayer());
                DevilFruitCapability.get((LivingEntity)event.getPlayer()).setDevilFruit(ModAbilities.YOMI_YOMI_NO_MI);
                DevilFruitCapability.get((LivingEntity)event.getPlayer()).setZoanPoint(YomiZoanInfo.INSTANCE.getForm());
                return;
            }
            if (CommonConfig.INSTANCE.getAfterDeathLogic() == CommonConfig.KeepStatsLogic.FULL) {
                ConfigEvents.restoreFullData(event.getOriginal(), event.getPlayer());
            } else if (CommonConfig.INSTANCE.getAfterDeathLogic() == CommonConfig.KeepStatsLogic.AUTO) {
                IEntityStats oldEntityStats = EntityStatsCapability.get((LivingEntity)event.getOriginal());
                String faction = oldEntityStats.getFaction();
                String race = oldEntityStats.getRace();
                String subRace = oldEntityStats.getSubRace();
                String fightStyle = oldEntityStats.getFightingStyle();
                int doriki = oldEntityStats.getDoriki() / 3;
                long bounty = oldEntityStats.getBounty() / 3L;
                long belly = oldEntityStats.getBelly() / 3L;
                long extol = oldEntityStats.getExtol() / 3L;
                IEntityStats newEntityStats = EntityStatsCapability.get((LivingEntity)event.getPlayer());
                newEntityStats.setFaction(faction);
                newEntityStats.setRace(race);
                newEntityStats.setSubRace(subRace);
                newEntityStats.setFightingStyle(fightStyle);
                newEntityStats.setMaxCola(100);
                newEntityStats.setCola(Math.min(oldEntityStats.getCola(), newEntityStats.getMaxCola()));
                newEntityStats.setDoriki(doriki);
                newEntityStats.setBounty(bounty);
                newEntityStats.setBelly(belly);
                newEntityStats.setExtol(extol);
                DorikiEvent e = new DorikiEvent(event.getPlayer(), newEntityStats.getDoriki());
                MinecraftForge.EVENT_BUS.post((Event)e);
                IHakiData oldHakiProps = HakiDataCapability.get((LivingEntity)event.getOriginal());
                float hardeningBusoExp = oldHakiProps.getBusoshokuHardeningHakiExp() / 2.0f;
                float imbuingBusoExp = oldHakiProps.getBusoshokuImbuingHakiExp() / 2.0f;
                float observationExp = oldHakiProps.getKenbunshokuHakiExp() / 2.0f;
                IHakiData newHakiProps = HakiDataCapability.get((LivingEntity)event.getPlayer());
                newHakiProps.setBusoshokuHardeningHakiExp(hardeningBusoExp);
                newHakiProps.setBusoshokuImbuingHakiExp(imbuingBusoExp);
                newHakiProps.setKenbunshokuHakiExp(observationExp);
            } else if (CommonConfig.INSTANCE.getAfterDeathLogic() == CommonConfig.KeepStatsLogic.CUSTOM) {
                IEntityStats oldEntityStats = EntityStatsCapability.get((LivingEntity)event.getOriginal());
                IEntityStats newEntityStats = EntityStatsCapability.get((LivingEntity)event.getPlayer());
                block20: for (String stat : CommonConfig.INSTANCE.getStatsToKeep()) {
                    switch (WyHelper.getResourceName(stat)) {
                        case "doriki": {
                            newEntityStats.setDoriki((int)WyHelper.percentage(CommonConfig.INSTANCE.getDorikiKeepPercentage(), oldEntityStats.getDoriki()));
                            DorikiEvent dorikiEvent = new DorikiEvent(event.getPlayer(), newEntityStats.getDoriki());
                            MinecraftForge.EVENT_BUS.post((Event)dorikiEvent);
                            continue block20;
                        }
                        case "bounty": {
                            newEntityStats.setBounty((int)WyHelper.percentage(CommonConfig.INSTANCE.getBountyKeepPercentage(), oldEntityStats.getBounty()));
                            BountyEvent bountyEvent = new BountyEvent(event.getPlayer(), newEntityStats.getBounty());
                            MinecraftForge.EVENT_BUS.post((Event)bountyEvent);
                            continue block20;
                        }
                        case "belly": {
                            newEntityStats.setBelly((int)WyHelper.percentage(CommonConfig.INSTANCE.getBellyKeepPercentage(), oldEntityStats.getBelly()));
                            continue block20;
                        }
                        case "race": {
                            newEntityStats.setRace(oldEntityStats.getRace());
                            newEntityStats.setSubRace(oldEntityStats.getSubRace());
                            continue block20;
                        }
                        case "faction": {
                            newEntityStats.setFaction(oldEntityStats.getFaction());
                            continue block20;
                        }
                        case "fighting_style": {
                            newEntityStats.setFightingStyle(oldEntityStats.getFightingStyle());
                            continue block20;
                        }
                        case "devil_fruit": {
                            nbt = DevilFruitCapability.INSTANCE.writeNBT((Object)oldDevilFruitProps, null);
                            DevilFruitCapability.INSTANCE.readNBT((Object)newDevilFruitProps, null, (INBT)nbt);
                            continue block20;
                        }
                        case "haki_exp": {
                            IHakiData oldHakiProps = HakiDataCapability.get((LivingEntity)event.getOriginal());
                            float hardeningBusoExp = oldHakiProps.getBusoshokuHardeningHakiExp() * ((float)CommonConfig.INSTANCE.getHakiExpKeepPercentage() / 100.0f);
                            float imbuingBusoExp = oldHakiProps.getBusoshokuImbuingHakiExp() * ((float)CommonConfig.INSTANCE.getHakiExpKeepPercentage() / 100.0f);
                            float observationExp = oldHakiProps.getKenbunshokuHakiExp() * ((float)CommonConfig.INSTANCE.getHakiExpKeepPercentage() / 100.0f);
                            IHakiData newHakiProps = HakiDataCapability.get((LivingEntity)event.getPlayer());
                            newHakiProps.setBusoshokuHardeningHakiExp(hardeningBusoExp);
                            newHakiProps.setBusoshokuImbuingHakiExp(imbuingBusoExp);
                            newHakiProps.setKenbunshokuHakiExp(observationExp);
                        }
                    }
                }
            }
            ConfigEvents.restorePermaData(event.getOriginal(), event.getPlayer());
            AbilityHelper.enableAbilities(event.getPlayer(), ability -> true);
            AbilityHelper.validateDevilFruitMoves(event.getPlayer());
            AbilityHelper.validateRacialMoves(event.getPlayer());
            AbilityHelper.validateStyleMoves(event.getPlayer());
            AbilityHelper.validateFactionMoves(event.getPlayer());
            WyNetwork.sendTo(new SSyncDevilFruitPacket(event.getPlayer().func_145782_y(), newDevilFruitProps), event.getPlayer());
            WyNetwork.sendTo(new SSyncAbilityDataPacket(event.getPlayer().func_145782_y(), newAbilityData), event.getPlayer());
            if (CommonConfig.INSTANCE.isSpecialFlyingEnabled() && AbilityDataCapability.get((LivingEntity)event.getPlayer()).hasUnlockedAbility(SpecialFlyAbility.INSTANCE) && !event.getPlayer().func_184812_l_() && !event.getPlayer().func_175149_v()) {
                event.getPlayer().field_71075_bZ.field_75101_c = false;
                event.getPlayer().field_71075_bZ.field_75100_b = false;
                ((ServerPlayerEntity)event.getPlayer()).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(event.getPlayer().field_71075_bZ));
            }
        } else {
            ConfigEvents.restoreFullData(event.getOriginal(), event.getPlayer());
        }
    }

    private static void restoreFullData(PlayerEntity original, PlayerEntity player) {
        IDevilFruit oldDevilFruitProps = DevilFruitCapability.get((LivingEntity)original);
        IDevilFruit newDevilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        IAbilityData newAbilityData = AbilityDataCapability.get((LivingEntity)player);
        CompoundNBT nbt = new CompoundNBT();
        IEntityStats oldEntityStats = EntityStatsCapability.get((LivingEntity)original);
        nbt = EntityStatsCapability.INSTANCE.writeNBT((Object)oldEntityStats, null);
        IEntityStats newEntityStats = EntityStatsCapability.get((LivingEntity)player);
        EntityStatsCapability.INSTANCE.readNBT((Object)newEntityStats, null, (INBT)nbt);
        newEntityStats.setMaxCola(100);
        newEntityStats.setHeart(true);
        newEntityStats.setShadow(true);
        newEntityStats.setStrawDoll(true);
        newEntityStats.setCola(Math.max(Math.min(oldEntityStats.getCola(), newEntityStats.getMaxCola()), 0));
        DorikiEvent e = new DorikiEvent(player, newEntityStats.getDoriki());
        MinecraftForge.EVENT_BUS.post((Event)e);
        nbt = DevilFruitCapability.INSTANCE.writeNBT((Object)oldDevilFruitProps, null);
        DevilFruitCapability.INSTANCE.readNBT((Object)newDevilFruitProps, null, (INBT)nbt);
        newDevilFruitProps.setZoanPoint("");
        IAbilityData oldAbilityData = AbilityDataCapability.get((LivingEntity)original);
        nbt = AbilityDataCapability.INSTANCE.writeNBT((Object)oldAbilityData, null);
        AbilityDataCapability.INSTANCE.readNBT((Object)newAbilityData, null, (INBT)nbt);
        IHakiData oldHakiData = HakiDataCapability.get((LivingEntity)original);
        nbt = HakiDataCapability.INSTANCE.writeNBT((Object)oldHakiData, null);
        IHakiData newHakiData = HakiDataCapability.get((LivingEntity)player);
        HakiDataCapability.INSTANCE.readNBT((Object)newHakiData, null, (INBT)nbt);
        ConfigEvents.restorePermaData(original, player);
    }

    private static void restorePermaData(PlayerEntity original, PlayerEntity player) {
        CompoundNBT nbt = new CompoundNBT();
        IQuestData oldQuestData = QuestDataCapability.get(original);
        nbt = QuestDataCapability.INSTANCE.writeNBT((Object)oldQuestData, null);
        IQuestData newQuestData = QuestDataCapability.get(player);
        QuestDataCapability.INSTANCE.readNBT((Object)newQuestData, null, (INBT)nbt);
        IChallengesData oldChallengeData = ChallengesDataCapability.get(original);
        nbt = ChallengesDataCapability.INSTANCE.writeNBT((Object)oldChallengeData, null);
        IChallengesData newChallengeData = ChallengesDataCapability.get(player);
        ChallengesDataCapability.INSTANCE.readNBT((Object)newChallengeData, null, (INBT)nbt);
        IAbilityData oldAbilityData = AbilityDataCapability.get((LivingEntity)original);
        oldAbilityData.clearEquippedAbilities(AbilityHelper.getAbilityFromCategoryPredicate(APIConfig.AbilityCategory.ALL));
        AbilityHelper.validateDevilFruitMoves(original);
        AbilityHelper.validateRacialMoves(original);
        AbilityHelper.validateStyleMoves(original);
        AbilityHelper.validateFactionMoves(original);
        nbt = AbilityDataCapability.INSTANCE.writeNBT((Object)oldAbilityData, null);
        IAbilityData newAbilityData = AbilityDataCapability.get((LivingEntity)player);
        AbilityDataCapability.INSTANCE.readNBT((Object)newAbilityData, null, (INBT)nbt);
    }
}

