/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class DamageSourceEvents {
    @SubscribeEvent
    public static void onEntityAttackEvent(LivingAttackEvent event) {
        if (!CommonConfig.INSTANCE.isSpecialSourceEventsEnabled()) {
            return;
        }
        Entity attacker = event.getSource().func_76364_f();
        LivingEntity entity = event.getEntityLiving();
        if (attacker instanceof OPEntity && ((OPEntity)attacker).hasBusoHaki()) {
            Item mainShield = entity.func_184614_ca().func_77973_b();
            Item secondaryShield = entity.func_184592_cb().func_77973_b();
            if (entity instanceof PlayerEntity && Math.random() > 0.5 && (mainShield.equals(Items.field_185159_cQ) || secondaryShield.equals(Items.field_185159_cQ))) {
                ((PlayerEntity)entity).func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                entity.func_184602_cy();
                entity.field_70170_p.func_72960_a(attacker, (byte)30);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDamageEvent(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || !(source instanceof ModDamageSource) || entity.func_70644_a(ModEffects.GUARDING)) {
            return;
        }
        switch (source.func_76355_l()) {
            case "lightningBolt": {
                if (DevilFruitCapability.get(entity).hasDevilFruit(ModAbilities.GOMU_GOMU_NO_MI) || DevilFruitCapability.get(entity).hasDevilFruit(ModAbilities.GORO_GORO_NO_MI)) {
                    return;
                }
                int time = Math.round(Math.min(0.1f * event.getAmount(), 5.0f) * 20.0f);
                EffectInstance instance = new EffectInstance(ModEffects.PARALYSIS, 10 + time, event.getAmount() > 12.0f ? 1 : 0);
                entity.func_195064_c(instance);
                if (!(source.func_76346_g() instanceof ServerPlayerEntity)) break;
                ((ServerPlayerEntity)source.func_76346_g()).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(entity.func_145782_y(), instance));
                break;
            }
            case "lava": {
                if (!CommonConfig.INSTANCE.isSpecialSourceEventsEnabled() || !(source.func_76346_g() instanceof PlayerEntity)) {
                    return;
                }
                entity.func_195063_d(Effects.field_76426_n);
                break;
            }
            case "onFire": {
                if (!CommonConfig.INSTANCE.isSpecialSourceEventsEnabled() || !(source.func_76346_g() instanceof PlayerEntity)) {
                    return;
                }
                AbilityHelper.reduceEffect(entity.func_70660_b(ModEffects.FROZEN), 2);
                AbilityHelper.reduceEffect(entity.func_70660_b(Effects.field_76426_n), 2);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurtEvent(LivingHurtEvent event) {
        PlayerEntity attackerPlayer;
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (source.func_76355_l().equals("lightningBolt") || source.func_76355_l().equals("lava") || source.func_76355_l().equals("onFire") || source.func_76355_l().equals("inFire")) {
            if (entity.func_70644_a(ModEffects.FROZEN)) {
                AbilityHelper.reduceEffect(entity.func_70660_b(ModEffects.FROZEN), 2);
                entity.func_70066_B();
                return;
            }
            if (entity.func_70644_a(ModEffects.FROSTBITE)) {
                entity.func_195063_d(ModEffects.FROSTBITE);
                entity.func_70066_B();
            }
            if (entity.func_70644_a(ModEffects.CANDLE_LOCK)) {
                entity.func_195063_d(ModEffects.CANDLE_LOCK);
                entity.func_70066_B();
            }
            if (entity.func_70644_a(ModEffects.CANDY_STUCK)) {
                entity.func_195063_d(ModEffects.CANDY_STUCK);
                entity.func_70066_B();
            }
        }
        if (event.getSource().func_76364_f() instanceof PlayerEntity && (attackerPlayer = (PlayerEntity)event.getSource().func_76364_f()).func_70644_a(ModEffects.DOKU_GUARD)) {
            EffectInstance effect = attackerPlayer.func_70660_b(ModEffects.DOKU_GUARD);
            int amplifier = 1 + effect.func_76458_c();
            entity.func_195064_c(new EffectInstance(Effects.field_76436_u, amplifier * 40, amplifier - 1));
        }
    }
}

