/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.effects.GuardingEffect;
import xyz.pixelatedw.mineminenomi.effects.HandcuffedEffect;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.mixins.EffectInstanceMixin;
import xyz.pixelatedw.mineminenomi.packets.server.SSetEffectDetailsPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class EffectsEvents {

    @Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
    public static class Client {
        private static final ArrayList<Effect> effects = new ArrayList<Effect>(Arrays.asList(ModEffects.HANDCUFFED, ModEffects.HANDCUFFED_KAIROSEKI, ModEffects.GUARDING, ModEffects.PARALYSIS, ModEffects.CANDY_STUCK, ModEffects.FROZEN));

        @SubscribeEvent
        public static void onMouseClicked(InputEvent.ClickInputEvent event) {
            if (event.getHand() == Hand.MAIN_HAND) {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                effects.stream().filter(arg_0 -> ((PlayerEntity)player).func_70644_a(arg_0)).forEach(eff -> {
                    event.setCanceled(true);
                    event.setSwingHand(false);
                });
            }
        }

        @SubscribeEvent
        public static void onShocked(EntityViewRenderEvent.CameraSetup event) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (!player.func_70644_a(ModEffects.DIZZY)) {
                return;
            }
            if (player.func_70660_b(ModEffects.DIZZY).func_76459_b() <= 0) {
                player.func_195063_d(ModEffects.DIZZY);
                return;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                event.setRoll((float)Math.sin(player.field_70173_aa % 100));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mineminenomi")
    public static class Common {
        private static final Effect[] UNREMOVEABLE_EFFECTS = new Effect[]{ModEffects.PARALYSIS, ModEffects.DRUNK, ModEffects.BLACK_BOX, ModEffects.ABILITY_OFF, ModEffects.DOOR_HEAD, ModEffects.CANDLE_LOCK, ModEffects.BUBBLY_CORAL, ModEffects.DRUNK, ModEffects.FROZEN, ModEffects.GANMEN_SEICHO_HORMONE, ModEffects.LOVESTRUCK, ModEffects.UNCONSCIOUS, ModEffects.NEGATIVE, ModEffects.MOVEMENT_BLOCKED, ModEffects.GUARDING, ModEffects.HANDCUFFED, ModEffects.HANDCUFFED_KAIROSEKI};

        @SubscribeEvent
        public static void onDrinkMilk(PotionEvent.PotionRemoveEvent event) {
            boolean isMilkBucket;
            if (event.getEntityLiving().func_184600_cs() == null) {
                return;
            }
            boolean bl = isMilkBucket = event.getEntityLiving().func_184586_b(event.getEntityLiving().func_184600_cs()).func_77973_b() == Items.field_151117_aB;
            if (isMilkBucket) {
                for (Effect effect : UNREMOVEABLE_EFFECTS) {
                    if (event.getPotion() != effect) continue;
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            LivingEntity entity = event.getEntityLiving();
            Entity source = event.getSource().func_76346_g();
            for (EffectInstance effectInstance : entity.func_70651_bq()) {
                if (effectInstance.func_188419_a() instanceof GuardingEffect) {
                    GuardingEffect instance = (GuardingEffect)effectInstance.func_188419_a();
                    if (instance.useOnlySources && !instance.acceptableSources.contains(event.getSource().func_76355_l())) {
                        return;
                    }
                    if (instance.reduceSpeedAfterHit) {
                        Objects.requireNonNull(entity);
                        entity.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 20, 1, false, false));
                    }
                    float power = (float)(effectInstance.func_76458_c() + 1) * 2.5f;
                    power *= event.getSource().func_76363_c() ? 0.8f : 1.0f;
                    if (event.getAmount() < power) {
                        entity.func_213293_j(0.0, 0.0, 0.0);
                        event.setAmount(0.0f);
                        event.setCanceled(true);
                    } else {
                        event.setAmount(event.getAmount() - power);
                    }
                    return;
                }
                if (!(effectInstance.func_188419_a() instanceof HandcuffedEffect)) continue;
                int dur = effectInstance.func_76459_b();
                double damage = event.getAmount();
                int newDur = (int)((double)dur - damage * 100.0);
                ((EffectInstanceMixin)effectInstance).setDuration(newDur);
                WyNetwork.sendToAllTrackingAndSelf(new SSetEffectDetailsPacket(entity.func_145782_y(), effectInstance), entity);
                if (effectInstance.func_76459_b() > 1 || !(entity instanceof PlayerEntity)) continue;
                PlayerEntity player = (PlayerEntity)entity;
                AbilityHelper.enableAbilities(player, ability -> ability.getCategory() == AbilityHelper.getDevilFruitCategory());
            }
        }
    }
}

