/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.events.SetPlayerDetailsEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.ProjectileHitEvent;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class FactionEvents {
    @SubscribeEvent
    public static void onEntityAttack(LivingHurtEvent event) {
        if (CommonConfig.INSTANCE.isFriendlyDamageDisabled() && event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity attacker = (PlayerEntity)event.getSource().func_76346_g();
            LivingEntity target = event.getEntityLiving();
            boolean sameGroup = FactionHelper.getSameGroupPredicate((LivingEntity)attacker).test((Entity)target);
            if (sameGroup) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileHit(ProjectileHitEvent event) {
        if (CommonConfig.INSTANCE.isFriendlyDamageDisabled() && event.getProjectile().func_85052_h() instanceof PlayerEntity && event.getHit().func_216346_c() == RayTraceResult.Type.ENTITY) {
            PlayerEntity attacker = (PlayerEntity)event.getProjectile().func_85052_h();
            EntityRayTraceResult hitResult = (EntityRayTraceResult)event.getHit();
            if (hitResult.func_216348_a() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)hitResult.func_216348_a();
                boolean sameGroup = FactionHelper.getSameGroupPredicate((LivingEntity)attacker).test((Entity)target);
                if (sameGroup) {
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSetFire(SetOnFireEvent event) {
        if (CommonConfig.INSTANCE.isFriendlyDamageDisabled() && event.getAttacker() instanceof PlayerEntity) {
            PlayerEntity attacker = (PlayerEntity)event.getAttacker();
            LivingEntity target = event.getEntityLiving();
            boolean sameGroup = FactionHelper.getSameGroupPredicate((LivingEntity)attacker).test((Entity)target);
            if (sameGroup) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onTargetSet(LivingSetAttackTargetEvent event) {
        boolean sameGroup;
        if (CommonConfig.INSTANCE.isFriendlyDamageDisabled() && event.getTarget() instanceof PlayerEntity && (sameGroup = FactionHelper.getSameGroupPredicate(event.getTarget()).test((Entity)event.getEntityLiving()))) {
            if (event.getEntityLiving() instanceof MobEntity) {
                ((MobEntity)event.getEntityLiving()).func_70624_b(null);
            }
            event.getEntityLiving().func_70604_c(null);
            event.getEntityLiving().func_130011_c(null);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinsWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity && !event.getWorld().field_72995_K && event.getWorld().field_73011_w.func_186058_p() == DimensionType.field_223227_a_) {
            FactionHelper.validateFaction((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onStatsChoose(SetPlayerDetailsEvent event) {
        FactionHelper.validateFaction(event.getPlayer());
    }
}

