/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.SpecialFlyAbility;
import xyz.pixelatedw.mineminenomi.api.ZoanInfo;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.packets.client.CSyncZoanPacket;
import xyz.pixelatedw.mineminenomi.renderers.entities.zoans.ZoanMorphRenderer;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
public class MorphEvents {
    @SubscribeEvent
    public static void onEntityRendered(RenderLivingEvent.Pre event) {
        AbstractClientPlayerEntity player;
        boolean ability;
        if (!(event.getEntity() instanceof AbstractClientPlayerEntity)) {
            return;
        }
        AbstractClientPlayerEntity entity = (AbstractClientPlayerEntity)event.getEntity();
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)entity);
        if (!WyHelper.isNullOrEmpty(props.getZoanPoint())) {
            ZoanInfo info;
            if (event.getEntity().field_70737_aN > 0) {
                // empty if block
            }
            if ((info = MorphHelper.getZoanInfo((LivingEntity)entity)) != null) {
                event.setCanceled(true);
                ZoanMorphRenderer render = (ZoanMorphRenderer)info.getRendererFactory().createRenderFor(Minecraft.func_71410_x().func_175598_ae());
                render.func_225623_a_(entity, entity.field_70177_z, event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), event.getLight());
            }
        }
        if ((ability = AbilityDataCapability.get((LivingEntity)(player = (AbstractClientPlayerEntity)event.getEntity())).hasUnlockedAbility(SpecialFlyAbility.INSTANCE)) && player.field_71075_bZ.field_75100_b && !player.field_71075_bZ.field_75098_d) {
            event.getMatrixStack().func_227860_a_();
            PlayerRenderer renderer = (PlayerRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)player);
            ((PlayerModel)renderer.func_217764_d()).field_178721_j.field_78806_j = false;
            ((PlayerModel)renderer.func_217764_d()).field_178722_k.field_78806_j = false;
            ((PlayerModel)renderer.func_217764_d()).field_178733_c.field_78806_j = false;
            ((PlayerModel)renderer.func_217764_d()).field_178731_d.field_78806_j = false;
            event.getMatrixStack().func_227865_b_();
        }
    }

    @SubscribeEvent
    public static void onEntityConstructing(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (player.field_70170_p.field_72995_K && clientPlayer != player) {
                WyNetwork.sendToServer(new CSyncZoanPacket(player.func_145782_y()));
            }
        }
    }

    @SubscribeEvent
    public static void onHandRendering(RenderHandEvent event) {
        boolean isOverlay;
        if (event.getHand() != Hand.MAIN_HAND) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        boolean renderHand = false;
        boolean hasEmptyHand = player.func_184614_ca().func_190926_b();
        ZoanInfo info = MorphHelper.getZoanInfo((LivingEntity)player);
        AbilityOverlay overlay = AbilityHelper.getCurrentOverlay((PlayerEntity)player);
        if (info != null && info.shouldRenderModelHand()) {
            renderHand = true;
        }
        boolean isZoan = hasEmptyHand && renderHand;
        boolean isBlackLeg = props.isBlackLeg() && hasEmptyHand;
        boolean bl = isOverlay = hasEmptyHand && overlay != null;
        if (isZoan || isOverlay || isBlackLeg) {
            event.setCanceled(true);
            MorphHelper.renderLimbFirstPerson(event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getEquipProgress(), event.getSwingProgress(), player.func_184591_cq(), overlay);
        }
    }

    @SubscribeEvent
    public static void onZoanSizeChange(EntityEvent.EyeHeight event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        float eyeHeight = player.func_213307_e(player.func_213283_Z());
        ZoanInfo info = null;
        if (!WyHelper.isNullOrEmpty(props.getZoanPoint())) {
            info = MorphHelper.getZoanInfo((LivingEntity)player);
            if (info.getHeight() <= 0.0) {
                return;
            }
            if (info != null && (eyeHeight = (float)(1.62 * (info.getHeight() / 1.75))) < 0.22f) {
                eyeHeight = 0.22f;
            }
        }
        if (info != null && player.func_225608_bj_()) {
            eyeHeight -= 0.3f;
        }
        event.setNewHeight(eyeHeight);
    }
}

