/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.events.DorikiEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncHakiDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SRecalculateEyeHeightPacket;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class SyncEvents {
    @SubscribeEvent
    public static void onDorikiGained(DorikiEvent event) {
        if (event.getPlayer() != null && CommonConfig.INSTANCE.isExtraHeartsEnabled()) {
            IAttributeInstance maxHpAttribute = event.getPlayer().func_110148_a(SharedMonsterAttributes.field_111267_a);
            IEntityStats props = EntityStatsCapability.get((LivingEntity)event.getPlayer());
            if (props.getDoriki() / 100 <= 20) {
                maxHpAttribute.func_111128_a(20.0);
            } else {
                maxHpAttribute.func_111128_a((double)(props.getDoriki() / 100));
            }
            ((ServerPlayerEntity)event.getPlayer()).field_71135_a.func_147359_a((IPacket)new SUpdateHealthPacket(event.getPlayer().func_110143_aJ(), event.getPlayer().func_71024_bL().func_75116_a(), event.getPlayer().func_71024_bL().func_75115_e()));
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (!player.field_70170_p.field_72995_K && player.field_70173_aa < 5) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SUpdateHealthPacket(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player = event.getPlayer();
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
        IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
        IHakiData hakiDataProps = HakiDataCapability.get((LivingEntity)player);
        WyNetwork.sendToAllTrackingAndSelf(new SSyncEntityStatsPacket(player.func_145782_y(), entityStatsProps), (LivingEntity)player);
        WyNetwork.sendToAllTrackingAndSelf(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), (LivingEntity)player);
        WyNetwork.sendToAllTrackingAndSelf(new SSyncAbilityDataPacket(player.func_145782_y(), abilityDataProps), (LivingEntity)player);
        WyNetwork.sendToAllTrackingAndSelf(new SSyncEntityStatsPacket(player.func_145782_y(), entityProps), (LivingEntity)player);
        WyNetwork.sendToAllTrackingAndSelf(new SSyncHakiDataPacket(player.func_145782_y(), hakiDataProps), (LivingEntity)player);
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.EyeHeight((Entity)player, player.func_213283_Z(), player.func_213305_a(player.func_213283_Z()), player.func_213302_cg()));
        WyNetwork.sendToAllTrackingAndSelf(new SRecalculateEyeHeightPacket(player.func_145782_y()), (LivingEntity)player);
    }

    @SubscribeEvent
    public static void onPlayerStartsTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof PlayerEntity) {
            PlayerEntity targetPlayer = (PlayerEntity)event.getTarget();
            IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)targetPlayer);
            IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)targetPlayer);
            IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)targetPlayer);
            IHakiData hakiDataProps = HakiDataCapability.get((LivingEntity)targetPlayer);
            WyNetwork.sendToAllTrackingAndSelf(new SSyncEntityStatsPacket(targetPlayer.func_145782_y(), entityStatsProps), (LivingEntity)targetPlayer);
            WyNetwork.sendToAllTrackingAndSelf(new SSyncDevilFruitPacket(targetPlayer.func_145782_y(), devilFruitProps), (LivingEntity)targetPlayer);
            WyNetwork.sendToAllTrackingAndSelf(new SSyncAbilityDataPacket(targetPlayer.func_145782_y(), abilityDataProps), (LivingEntity)targetPlayer);
            WyNetwork.sendToAllTrackingAndSelf(new SSyncHakiDataPacket(targetPlayer.func_145782_y(), hakiDataProps), (LivingEntity)targetPlayer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onEntityJoinsWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ClientPlayerEntity) {
            // empty if block
        }
    }
}

