/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.devilfruits;

import java.util.List;
import java.util.Objects;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class DFWeaknessesEvents {
    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        if (props.hasDevilFruit() && AbilityHelper.isAffectedByWater((LivingEntity)player) && !player.func_70644_a(ModEffects.BUBBLY_CORAL)) {
            event.setNewSpeed(event.getOriginalSpeed() / 15.0f);
        }
    }

    @SubscribeEvent
    public static void onEntityLeftClickBlocks(PlayerInteractEvent.LeftClickBlock event) {
        if (!CommonConfig.INSTANCE.areExtraWaterChecksEnabled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        if (props.hasDevilFruit() && AbilityHelper.isAffectedByWater((LivingEntity)player) && !player.func_70644_a(ModEffects.BUBBLY_CORAL)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityRightClickEmpty(PlayerInteractEvent.RightClickItem event) {
        if (!CommonConfig.INSTANCE.areExtraWaterChecksEnabled() || event.getItemStack().func_77973_b().equals(ModItems.BUBBLY_CORAL)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        if (props.hasDevilFruit() && AbilityHelper.isAffectedByWater((LivingEntity)player) && !player.func_70644_a(ModEffects.BUBBLY_CORAL)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityRightClickBlocks(PlayerInteractEvent.RightClickBlock event) {
        if (!CommonConfig.INSTANCE.areExtraWaterChecksEnabled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        if (props.hasDevilFruit() && AbilityHelper.isAffectedByWater((LivingEntity)player) && !player.func_70644_a(ModEffects.BUBBLY_CORAL)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityBreaksBlocks(BlockEvent.BreakEvent event) {
        if (!CommonConfig.INSTANCE.areExtraWaterChecksEnabled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        if (props.hasDevilFruit() && AbilityHelper.isAffectedByWater((LivingEntity)player) && !player.func_70644_a(ModEffects.BUBBLY_CORAL)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityPlaceBlocks(BlockEvent.EntityPlaceEvent event) {
        if (!CommonConfig.INSTANCE.areExtraWaterChecksEnabled() || !(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        if (props.hasDevilFruit() && AbilityHelper.isAffectedByWater((LivingEntity)player) && !player.func_70644_a(ModEffects.BUBBLY_CORAL)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() != null) {
            LivingEntity entity = event.getEntityLiving();
            IDevilFruit props = DevilFruitCapability.get(entity);
            if (!props.hasDevilFruit()) {
                return;
            }
            if (AbilityHelper.isAffectedByWater(entity) && !entity.func_70644_a(ModEffects.BUBBLY_CORAL)) {
                if (entity instanceof PlayerEntity && !((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
                    if (entity.func_213314_bj()) {
                        entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b - 0.1, entity.func_213322_ci().field_72449_c);
                    } else {
                        entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b - 0.04, entity.func_213322_ci().field_72449_c);
                    }
                    if (CommonConfig.INSTANCE.areExtraWaterChecksEnabled()) {
                        ((PlayerEntity)entity).func_71020_j(0.015f);
                    }
                } else if (entity instanceof OPEntity) {
                    entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b - 0.04, entity.func_213322_ci().field_72449_c);
                }
            }
            if (event.getEntityLiving() instanceof PlayerEntity) {
                boolean hasWaterWeakness;
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                player.field_70170_p.func_217381_Z().func_76320_a("playerDevilFruitWeakness");
                boolean bl = hasWaterWeakness = AbilityHelper.isNearbyKairoseki(player) && !player.func_70644_a(ModEffects.BUBBLY_CORAL);
                if (!player.field_70170_p.field_72995_K && CommonConfig.INSTANCE.areExtraWaterChecksEnabled()) {
                    boolean hasExtraWaterTime = DFWeaknessesEvents.scoreCheck(player, hasWaterWeakness);
                    if (hasWaterWeakness && hasExtraWaterTime) {
                        return;
                    }
                }
                if (!player.field_70170_p.field_72995_K) {
                    if (hasWaterWeakness) {
                        player.func_195064_c(new EffectInstance(Effects.field_76437_t, 20, 0));
                        player.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 0));
                        player.func_195064_c(new EffectInstance(Effects.field_76419_f, 20, 0));
                        player.func_71020_j(0.05f);
                        AbilityHelper.disableAbilities(player, 20, ability -> true);
                    } else {
                        AbilityHelper.enableAbilities(player, ability -> true);
                    }
                }
                player.field_70170_p.func_217381_Z().func_76319_b();
            }
        }
    }

    public static boolean scoreCheck(PlayerEntity player, boolean value) {
        Scoreboard scoreboard = player.field_70170_p.func_96441_U();
        if (!scoreboard.func_197897_d().contains("watertime_mmnm")) {
            scoreboard.func_199868_a("watertime_mmnm", ScoreCriteria.field_96641_b, (ITextComponent)new StringTextComponent("waterTime"), ScoreCriteria.RenderType.INTEGER);
        }
        Score score = scoreboard.func_96529_a(player.func_110124_au().toString(), Objects.requireNonNull(scoreboard.func_96518_b("watertime_mmnm")));
        if (value) {
            List<BlockPos> blockPosList = WyHelper.getNearbyBlocks((LivingEntity)player, 1);
            float size = (float)blockPosList.stream().map(pos -> player.field_70170_p.func_180495_p(pos).func_177230_c()).filter(block -> block.equals(Blocks.field_150355_j)).count() / 4.0f;
            if (0.0f >= size) {
                size = 1.0f;
            }
            score.func_96649_a(Math.round(size));
            return score.func_96652_c() <= 60;
        }
        score.func_197891_c();
        return false;
    }
}

