/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.passives;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.doa.AirDoorAbility;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class DoaPassiveEvents {
    @SubscribeEvent
    public static void onEntityHits(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityLeftClickBlocks(PlayerInteractEvent.LeftClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityRightClickBlocks(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityBreaksBlocks(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityPlaceBlocks(BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityTargetedEvent(LivingSetAttackTargetEvent event) {
        if (!(event.getTarget() instanceof PlayerEntity) || event.getTarget() instanceof FakePlayer || !(event.getEntity() instanceof MobEntity)) {
            return;
        }
        if (!DoaPassiveEvents.isInsideDoor((PlayerEntity)event.getTarget())) {
            return;
        }
        MobEntity entity = (MobEntity)event.getEntity();
        entity.func_70624_b(null);
    }

    public static boolean isInsideDoor(PlayerEntity player) {
        boolean isActive;
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        if (!devilFruitProps.hasDevilFruit(ModAbilities.DOA_DOA_NO_MI)) {
            return false;
        }
        AirDoorAbility ability = abilityProps.getEquippedAbility(AirDoorAbility.INSTANCE);
        boolean bl = isActive = ability != null && ability.isContinuous();
        return isActive;
    }

    @Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
    public static class Client {
        @SubscribeEvent
        public static void onPlayerCameraSetup(EntityViewRenderEvent.CameraSetup event) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (!player.func_70644_a(ModEffects.DOOR_HEAD)) {
                return;
            }
            if (player.func_70660_b(ModEffects.DOOR_HEAD).func_76459_b() <= 0) {
                player.func_195063_d(ModEffects.DOOR_HEAD);
                return;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                event.setYaw((float)(player.field_70173_aa * 10 % 360));
            }
        }

        @SubscribeEvent
        public static void onEntityRendered(RenderLivingEvent.Pre event) {
            LivingEntity entity = event.getEntity();
            if (entity.func_70644_a(ModEffects.DOOR_HEAD)) {
                if (entity.func_70660_b(ModEffects.DOOR_HEAD).func_76459_b() <= 0) {
                    entity.func_195063_d(ModEffects.DOOR_HEAD);
                    return;
                }
                entity.field_70761_aq = 0.0f;
                entity.field_70760_ar = 0.0f;
            }
            IDevilFruit devilFruitProps = DevilFruitCapability.get(entity);
            IAbilityData abilityProps = AbilityDataCapability.get(entity);
            if (devilFruitProps.hasDevilFruit(ModAbilities.DOA_DOA_NO_MI)) {
                boolean isActive;
                AirDoorAbility ability = abilityProps.getEquippedAbility(AirDoorAbility.INSTANCE);
                boolean bl = isActive = ability != null && ability.isContinuous();
                if (isActive) {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onEntityRendered(RenderLivingEvent.Post event) {
            LivingEntity entity = event.getEntity();
            if (!entity.func_70644_a(ModEffects.DOOR_HEAD)) {
                return;
            }
            if (entity.func_70660_b(ModEffects.DOOR_HEAD).func_76459_b() <= 0) {
                entity.func_195063_d(ModEffects.DOOR_HEAD);
                return;
            }
            entity.field_70759_as += 10.0f;
            entity.field_70758_at += 10.0f;
            entity.field_70761_aq = 0.0f;
            entity.field_70760_ar = 0.0f;
        }

        @SubscribeEvent
        public static void onFirstPersonViewRendered(TickEvent.RenderTickEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (player == null) {
                return;
            }
            if (!DoaPassiveEvents.isInsideDoor((PlayerEntity)player)) {
                return;
            }
            WyHelper.drawColourOnScreen(WyHelper.hexToRGB("#2AFFAE").getRGB(), 50, 0.0, 0.0, mc.func_228018_at_().func_198107_o(), mc.func_228018_at_().func_198087_p(), 500.0);
        }
    }
}

