/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.passives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.LogiaInvulnerabilityAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.items.weapons.CoreSwordItem;
import xyz.pixelatedw.mineminenomi.mixins.client.BlockRendererDispatcherMixin;
import xyz.pixelatedw.mineminenomi.mixins.client.WorldRendererMixin;
import xyz.pixelatedw.mineminenomi.renderers.LavaVisionFluidRenderer;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class MaguPassiveEvents {
    public static final LogiaInvulnerabilityAbility INVULNERABILITY_INSTANCE = new LogiaInvulnerabilityAbility(ModParticleTypes.MAGU, "Magu", MaguPassiveEvents::maguDamage, DamageSource.field_76372_a, DamageSource.field_76370_b, DamageSource.field_76371_c, DamageSource.field_190095_e);
    private static final ArrayList<String> fireFruits = new ArrayList<String>(Arrays.asList("magu_magu", "mera_mera", "goro_goro"));
    private static boolean UpdateMaguVision = false;
    private static FluidBlockRenderer previousFluidRenderer;

    public static boolean maguDamage(LivingEntity target, LivingEntity attacker) {
        if (CommonConfig.INSTANCE.isLogiaDamageEffectEnabled()) {
            ItemStack stack;
            SetOnFireEvent event = new SetOnFireEvent(attacker, target, 8);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                attacker.func_70015_d(5);
            }
            if ((stack = attacker.func_184614_ca()).func_77973_b() instanceof CoreSwordItem) {
                stack.func_222118_a(stack.func_77958_k() / 10 + 1, target, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
            }
            attacker.func_70097_a(DamageSource.field_76371_c, 10.0f);
        }
        return false;
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        if (!devilFruitProps.hasDevilFruit(ModAbilities.MAGU_MAGU_NO_MI)) {
            return;
        }
        if (player.func_180799_ab() && !player.field_71075_bZ.field_75100_b) {
            float a = player.field_191988_bg > 0.0f ? 2.0f : 0.5f;
            float y = player.func_225608_bj_() && !(player.func_226278_cu_() - player.field_70167_r > 0.0) ? 2.0f : 0.0f;
            Vec3d vec3d = player.func_213322_ci().func_216372_d((double)a, (double)y, (double)a);
            if (AbilityHelper.isJumping((LivingEntity)player)) {
                player.func_213317_d(vec3d.func_72441_c(0.0, (double)0.4f, 0.0));
            } else {
                player.func_213317_d(vec3d);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        if (!fireFruits.contains(devilFruitProps.getDevilFruit())) {
            return;
        }
        if (event.getOverlayType().equals((Object)RenderBlockOverlayEvent.OverlayType.FIRE)) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onEntityInLava(EntityViewRenderEvent.FogDensity event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        if (!devilFruitProps.hasDevilFruit(ModAbilities.MAGU_MAGU_NO_MI)) {
            return;
        }
        if (player.func_208600_a(FluidTags.field_206960_b)) {
            event.setDensity(0.025f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        if (devilFruitProps.hasDevilFruit(ModAbilities.MAGU_MAGU_NO_MI)) {
            if (!UpdateMaguVision) {
                RenderType lavaType = RenderType.func_228645_f_();
                RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_204547_b, (RenderType)lavaType);
                RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_207213_d, (RenderType)lavaType);
                BlockRendererDispatcherMixin blockrenderer = (BlockRendererDispatcherMixin)Minecraft.func_71410_x().func_175602_ab();
                previousFluidRenderer = blockrenderer.getfluidRenderer();
                blockrenderer.setfluidRenderer(new LavaVisionFluidRenderer());
                MaguPassiveEvents.updateAllChunks();
            }
        } else if (UpdateMaguVision) {
            if (previousFluidRenderer != null) {
                RenderType lavaType = RenderType.func_228639_c_();
                RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_204547_b, (RenderType)lavaType);
                RenderTypeLookup.setRenderLayer((Fluid)Fluids.field_207213_d, (RenderType)lavaType);
                BlockRendererDispatcherMixin blockrenderer = (BlockRendererDispatcherMixin)Minecraft.func_71410_x().func_175602_ab();
                blockrenderer.setfluidRenderer(previousFluidRenderer);
            }
            MaguPassiveEvents.updateAllChunks();
        }
        UpdateMaguVision = devilFruitProps.hasDevilFruit(ModAbilities.MAGU_MAGU_NO_MI);
    }

    private static void updateAllChunks() {
        ViewFrustum viewFrustum = ((WorldRendererMixin)Minecraft.func_71410_x().field_71438_f).getViewFrustum();
        if (viewFrustum != null) {
            IntStream.range(0, viewFrustum.field_178164_f.length).forEach(i -> viewFrustum.field_178164_f[i].func_178575_a(true));
        }
    }
}

