/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.passives;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.yomi.KasuriutaFubukiGiriAbility;
import xyz.pixelatedw.mineminenomi.abilities.yomi.SoulParadeAbility;
import xyz.pixelatedw.mineminenomi.abilities.yomi.YomiNoReikiAbility;
import xyz.pixelatedw.mineminenomi.api.ZoanInfo;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.events.YomiTriggerEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.entities.zoan.YomiZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.models.entities.zoans.YomiModel;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.renderers.entities.zoans.ZoanMorphRenderer;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.AbilityUseEvent;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class YomiPassiveEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD && props.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) && YomiZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClonePlayer(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            IDevilFruit oldPlayerProps = DevilFruitCapability.get((LivingEntity)event.getOriginal());
            IDevilFruit newPlayerProps = DevilFruitCapability.get((LivingEntity)event.getPlayer());
            YomiTriggerEvent yomiEvent = new YomiTriggerEvent(event.getPlayer(), oldPlayerProps, newPlayerProps);
            if (MinecraftForge.EVENT_BUS.post((Event)yomiEvent)) {
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        if (!devilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) || !YomiZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            return;
        }
        player.func_71024_bL().func_75122_a(9999, 9999.0f);
        player.func_195064_c(new EffectInstance(Effects.field_76424_c, 100, 0, false, false));
        if (player.field_70173_aa % 500 == 0) {
            WyNetwork.sendTo(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), player);
            if (WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 100.0, PlayerEntity.class).size() > 0) {
                WyNetwork.sendToAllAround(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), (LivingEntity)player);
            }
        }
        if (player.field_70170_p.func_180495_p(player.func_180425_c().func_177977_b()).func_204520_s().func_206889_d() && player.func_70051_ag()) {
            player.field_70122_E = true;
            if (player.func_213322_ci().field_72448_b <= 0.0 && player.func_213322_ci().field_72448_b < 0.009) {
                Vec3d speed = WyHelper.propulsion((LivingEntity)player, 0.4, 0.4);
                double ySpeed = 0.0 - player.func_213322_ci().field_72448_b;
                if (ySpeed > 0.008) {
                    ySpeed = 0.008;
                }
                player.func_213293_j(speed.field_72450_a, ySpeed, speed.field_72449_c);
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
                player.field_70143_R = 0.0f;
            }
            BlockState blockState = player.field_70170_p.func_180495_p(player.func_180425_c().func_177977_b());
            for (int i = 0; i < 10; ++i) {
                double newPosX = player.func_226277_ct_() + WyHelper.randomDouble();
                double newPosY = player.func_226278_cu_();
                double newPosZ = player.func_226281_cx_() + WyHelper.randomDouble();
                ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), newPosX, newPosY, newPosZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        if (!devilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) || !YomiZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            return;
        }
        event.setAmount(event.getAmount() * 0.75f);
    }

    @SubscribeEvent
    public static void onSpiritUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        if (!devilFruitProps.getDevilFruit().equals("yomi_yomi") || player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        if (!YomiPassiveEvents.isSpirit(player)) {
            player.field_70145_X = false;
            player.field_71075_bZ.field_75100_b = false;
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).func_71016_p();
            }
            return;
        }
        player.field_70122_E = false;
        player.field_70145_X = true;
        player.field_71075_bZ.field_75100_b = true;
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).func_71016_p();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityRendered(RenderLivingEvent.Pre event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!YomiPassiveEvents.isSpirit(player)) {
            return;
        }
        ZoanInfo info = MorphHelper.getZoanInfo((LivingEntity)player);
        ZoanMorphRenderer render = (ZoanMorphRenderer)info.getRendererFactory().createRenderFor(Minecraft.func_71410_x().func_175598_ae());
        IVertexBuilder vertex = event.getBuffers().getBuffer(RenderType.func_228644_e_((ResourceLocation)render.func_110775_a((AbstractClientPlayerEntity)player)));
        event.setCanceled(true);
        event.getMatrixStack().func_227860_a_();
        event.getMatrixStack().func_227861_a_(0.0, 1.5, 0.0);
        event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 180.0f, true));
        event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
        event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229181_d_, player.field_70126_B + (player.field_70177_z - player.field_70126_B) * event.getPartialRenderTick() - 180.0f, true));
        event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229179_b_, player.field_70127_C + (player.field_70125_A - player.field_70127_C) * event.getPartialRenderTick(), true));
        ((YomiModel)render.func_217764_d()).field_78116_c.func_228309_a_(event.getMatrixStack(), vertex, event.getLight(), OverlayTexture.field_229196_a_, 0.3f, 0.9f, 0.5f, 0.6f);
        event.getMatrixStack().func_227860_a_();
        IVertexBuilder vertexBuilder = event.getBuffers().getBuffer(RenderType.func_228657_l_());
        event.getMatrixStack().func_227861_a_(0.0, -0.35, 0.0);
        float randMovement = ((float)(player.field_70173_aa / 200) + event.getPartialRenderTick()) / 500.0f;
        for (int i = 0; i < 100; ++i) {
            event.getMatrixStack().func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f + randMovement * 90.0f));
            float f3 = 0.6f * player.func_70681_au().nextFloat();
            float f4 = 0.6f * player.func_70681_au().nextFloat();
            Matrix4f matrix4f = event.getMatrixStack().func_227866_c_().func_227870_a_();
            int alpha = 5;
            Color primaryColor = new Color(0, 255, 0, alpha);
            Color secondaryColor = new Color(0, 255, 50, alpha);
            RendererHelper.drawA(vertexBuilder, matrix4f, primaryColor);
            RendererHelper.drawB(vertexBuilder, matrix4f, f3, f4, secondaryColor);
            RendererHelper.drawC(vertexBuilder, matrix4f, f3, f4, secondaryColor);
            RendererHelper.drawA(vertexBuilder, matrix4f, primaryColor);
            RendererHelper.drawC(vertexBuilder, matrix4f, f3, f4, secondaryColor);
            RendererHelper.drawD(vertexBuilder, matrix4f, f3, f4, secondaryColor);
            RendererHelper.drawA(vertexBuilder, matrix4f, primaryColor);
            RendererHelper.drawD(vertexBuilder, matrix4f, f3, f4, secondaryColor);
            RendererHelper.drawB(vertexBuilder, matrix4f, f3, f4, secondaryColor);
        }
        event.getMatrixStack().func_227865_b_();
        event.getMatrixStack().func_227865_b_();
    }

    @SubscribeEvent
    public static void onEntityHits(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!YomiPassiveEvents.isSpirit(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityLeftClickBlocks(PlayerInteractEvent.LeftClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (!YomiPassiveEvents.isSpirit(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityRightClickBlocks(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (!YomiPassiveEvents.isSpirit(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityBreaksBlocks(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!YomiPassiveEvents.isSpirit(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityPlaceBlocks(BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!YomiPassiveEvents.isSpirit(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityAttackEvent(LivingAttackEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (YomiPassiveEvents.isSpirit(player) && event.getSource() != DamageSource.field_76376_m) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAbilityUse(AbilityUseEvent event) {
        PlayerEntity player = event.getPlayer();
        if (event.getAbility() instanceof YomiNoReikiAbility || event.getAbility() instanceof SoulParadeAbility || event.getAbility() instanceof KasuriutaFubukiGiriAbility) {
            return;
        }
        if (YomiPassiveEvents.isSpirit(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(LivingHurtEvent event) {
        boolean isActive;
        if (!(event.getSource().func_76364_f() instanceof LivingEntity) || !(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)event.getSource().func_76364_f();
        PlayerEntity attacked = (PlayerEntity)event.getEntityLiving();
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)attacked);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)attacked);
        if (!devilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) || attacker == null) {
            return;
        }
        SoulParadeAbility ability = abilityProps.getEquippedAbility(SoulParadeAbility.INSTANCE);
        boolean bl = isActive = ability != null && ability.isContinuous();
        if (YomiZoanInfo.INSTANCE.isActive((LivingEntity)attacked) && isActive) {
            attacker.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 1));
            attacker.func_195064_c(new EffectInstance(Effects.field_76419_f, 100, 1));
            EffectInstance instance = new EffectInstance(ModEffects.FROZEN, 100, 0);
            attacker.func_195064_c(instance);
            ((ServerPlayerEntity)attacked).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(attacker.func_145782_y(), instance));
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)attacked, attacked.field_70170_p, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), 2.0f);
            explosion.setDamageOwner(false);
            explosion.setDestroyBlocks(false);
            explosion.setSmokeParticles(SoulParadeAbility.PARTICLES);
            explosion.doExplosion();
        }
    }

    @SubscribeEvent
    public static void onDrinkMilk(LivingEntityUseItemEvent.Finish event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        IDevilFruit devilFruitProps = DevilFruitCapability.get(event.getEntityLiving());
        if (!devilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI)) {
            return;
        }
        if (event.getItem().func_77973_b() == Items.field_151117_aB && YomiZoanInfo.INSTANCE.isActive(event.getEntityLiving())) {
            event.getEntityLiving().func_70691_i(8.0f);
        }
    }

    private static boolean isSpirit(PlayerEntity player) {
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        if (!devilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) || player.func_184812_l_() || player.func_175149_v()) {
            return false;
        }
        YomiNoReikiAbility ability = abilityProps.getEquippedAbility(YomiNoReikiAbility.INSTANCE);
        return ability != null && ability.isContinuous();
    }
}

