/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;

public class AkumaNoMiBoxItem
extends Item {
    private int tier;

    public AkumaNoMiBoxItem(int tier) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.MISC).func_200917_a(1));
        this.tier = tier;
    }

    public int getKeySlot(PlayerEntity player) {
        if (!player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.KEY))) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_MESSAGE_NEED_KEY, new Object[0]));
            return -1;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_190926_b() || stack.func_77973_b() != ModItems.KEY) continue;
            return i;
        }
        return -1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K) {
            if (hand.equals((Object)Hand.OFF_HAND)) {
                return new ActionResult(ActionResultType.FAIL, (Object)player.func_184586_b(hand));
            }
            int keySlot = this.getKeySlot(player);
            if (keySlot < 0) {
                return new ActionResult(ActionResultType.FAIL, (Object)player.func_184586_b(hand));
            }
            ItemStack itemStack = player.func_184614_ca();
            player.field_71071_by.func_70298_a(keySlot, 1);
            player.field_71071_by.func_184437_d(itemStack);
            Item randomFruit = DevilFruitHelper.rouletteDevilFruits(world, this.tier);
            randomFruit = DevilFruitHelper.oneFruitPerWorldCheck(world, randomFruit);
            if (randomFruit == null) {
                player.field_71071_by.func_184437_d(itemStack);
                return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
            }
            if (randomFruit != null) {
                if (!(randomFruit instanceof AkumaNoMiItem)) {
                    player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)randomFruit));
                    return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
                }
                if (DevilFruitHelper.hasDFLimitInInventory(player)) {
                    player.func_71019_a(new ItemStack((IItemProvider)randomFruit), true);
                    return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
                }
                player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)randomFruit));
                ExtendedWorldData worldProps = ExtendedWorldData.get(player.field_70170_p);
                worldProps.addDevilFruitInInventory(player.func_110124_au(), DevilFruitHelper.getDevilFruitKey((AkumaNoMiItem)randomFruit));
                return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }
}

