/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.HopperMinecartEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.enums.AbilityCommandGroup;
import xyz.pixelatedw.mineminenomi.api.enums.FruitType;
import xyz.pixelatedw.mineminenomi.api.events.EatDevilFruitEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.DFItemEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PassiveAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

public class AkumaNoMiItem
extends Item {
    private String name;
    private int tier;
    public FruitType type;
    public Ability[] abilities;

    public AkumaNoMiItem(String name, int tier, FruitType type, Ability ... abilitiesArray) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.DEVIL_FRUITS).func_200917_a(1).func_221540_a(Foods.field_221425_a));
        this.name = name;
        this.type = type;
        this.abilities = abilitiesArray;
        this.tier = tier;
        if (this.type == FruitType.LOGIA) {
            ModValues.logias.add(this);
        }
        ModValues.devilfruits.add(this);
        AbilityCommandGroup.create(this.name.toUpperCase().replaceAll(" ", "_"), () -> this.abilities);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, LivingEntity livingEntity) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return itemStack;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        EatDevilFruitEvent.Pre preEvent = new EatDevilFruitEvent.Pre(player, itemStack);
        if (MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
            return itemStack;
        }
        if (!player.field_70170_p.field_72995_K) {
            IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
            IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
            IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
            ExtendedWorldData worldData = ExtendedWorldData.get(world);
            String eatenFruit = DevilFruitHelper.getDevilFruitKey(this);
            if (CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic() && worldData.getAteFruits().containsValue(eatenFruit)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_MESSAGE_FRUIT_ALREADY_USED, new Object[0]));
                itemStack.func_190918_g(1);
                return itemStack;
            }
            boolean hasFruit = !WyHelper.isNullOrEmpty(devilFruitProps.getDevilFruit());
            boolean hasYami = devilFruitProps.hasDevilFruit(ModAbilities.YAMI_YAMI_NO_MI);
            if (!CommonConfig.INSTANCE.isYamiPowerEnabled() && hasFruit) {
                this.applyCurseDeath(player);
                itemStack.func_190918_g(1);
                return itemStack;
            }
            if (CommonConfig.INSTANCE.isYamiPowerEnabled()) {
                if (hasFruit && itemStack.func_77973_b() != ModAbilities.YAMI_YAMI_NO_MI && !hasYami) {
                    this.applyCurseDeath(player);
                    itemStack.func_190918_g(1);
                    worldData.removeDevilFruitInInventory(player.func_110124_au(), eatenFruit);
                    worldData.removeDevilFruitInWorld(eatenFruit);
                    return itemStack;
                }
                if (itemStack.func_77973_b() == ModAbilities.YAMI_YAMI_NO_MI && hasYami) {
                    this.applyCurseDeath(player);
                    itemStack.func_190918_g(1);
                    worldData.removeDevilFruitInInventory(player.func_110124_au(), eatenFruit);
                    worldData.removeDevilFruitInWorld(eatenFruit);
                    return itemStack;
                }
                if (hasFruit && !devilFruitProps.getDevilFruit().equalsIgnoreCase("yami_yami") && devilFruitProps.hasYamiPower()) {
                    this.applyCurseDeath(player);
                    itemStack.func_190918_g(1);
                    worldData.removeDevilFruitInInventory(player.func_110124_au(), eatenFruit);
                    worldData.removeDevilFruitInWorld(eatenFruit);
                    return itemStack;
                }
            }
            if (this.type == FruitType.LOGIA) {
                devilFruitProps.setLogia(true);
            }
            if (itemStack.func_77973_b() == ModAbilities.YAMI_YAMI_NO_MI) {
                devilFruitProps.setLogia(false);
                if (CommonConfig.INSTANCE.isYamiPowerEnabled()) {
                    devilFruitProps.setYamiPower(true);
                }
            } else if (devilFruitProps.hasYamiPower()) {
                devilFruitProps.setLogia(false);
            }
            if (itemStack.func_77973_b() == ModAbilities.HITO_HITO_NO_MI) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_MESSAGE_GAINED_ENLIGHTENMENT, new Object[0]));
                entityStatsProps.setRace("human");
                AbilityHelper.validateStyleMoves(player);
                AbilityHelper.validateRacialMoves(player);
                WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), entityStatsProps), player);
            }
            if (itemStack.func_77973_b() != ModAbilities.YOMI_YOMI_NO_MI) {
                for (Ability a : this.abilities) {
                    if (AbilityHelper.verifyIfAbilityIsBanned(a) || abilityDataProps.getUnlockedAbility(a) != null) continue;
                    abilityDataProps.addUnlockedAbility(a);
                }
                WyNetwork.sendTo(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), player);
                WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), abilityDataProps), player);
            }
            if (CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
                worldData.addAteDevilFruit(player, this);
                worldData.removeDevilFruitInInventory(player.func_110124_au(), eatenFruit);
            }
            if (!hasFruit || hasYami && CommonConfig.INSTANCE.isYamiPowerEnabled()) {
                devilFruitProps.setDevilFruit(eatenFruit);
                WyNetwork.sendTo(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), player);
            }
            player.func_71024_bL().func_75122_a(12, 4.0f);
        }
        EatDevilFruitEvent.Post postEvent = new EatDevilFruitEvent.Post(player, itemStack);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        itemStack.func_190918_g(1);
        return itemStack;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag par4) {
        for (int i = 0; i < this.abilities.length; ++i) {
            if (AbilityHelper.verifyIfAbilityIsBanned(this.abilities[i]) || this.abilities[i] == null || this.abilities[i] instanceof PassiveAbility) continue;
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)("ability.mineminenomi." + WyHelper.getResourceName(this.abilities[i].getName())), (Object[])new Object[0])));
        }
        list.add((ITextComponent)new StringTextComponent(""));
        list.add((ITextComponent)new StringTextComponent(this.type.getColor() + this.type.getName()));
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity entity, ItemStack itemStack) {
        if (((ItemEntity)entity).func_200214_m() == null) {
            return null;
        }
        DFItemEntity newEntity = new DFItemEntity(world, entity.func_213303_ch().field_72450_a, entity.func_213303_ch().field_72448_b, entity.func_213303_ch().field_72449_c, itemStack);
        newEntity.func_174867_a(40);
        newEntity.func_213317_d(entity.func_213322_ci());
        return newEntity;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        List foxes;
        List hopperMinecarts;
        boolean entityInVoidCheck;
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        ExtendedWorldData worldData = ExtendedWorldData.get(entity.field_70170_p);
        boolean chunkExistsCheck = !entity.field_70170_p.func_217354_b(entity.func_180425_c().func_177958_n() >> 4, entity.func_180425_c().func_177952_p() >> 4);
        boolean entityBurningCheck = entity.func_70027_ad();
        boolean bl = entityInVoidCheck = entity.func_180425_c().func_177956_o() < -1;
        if (chunkExistsCheck || entityBurningCheck || entityInVoidCheck) {
            entity.func_70106_y();
            worldData.removeDevilFruitInWorld(this);
        }
        boolean shouldRemove = false;
        List<BlockPos> blockPosList = WyHelper.getNearbyTileEntities(entity.func_180425_c(), entity.field_70170_p, 2);
        for (BlockPos pos : blockPosList) {
            TileEntity te = entity.field_70170_p.func_175625_s(pos);
            if (!(te instanceof HopperTileEntity)) continue;
            shouldRemove = true;
            break;
        }
        if ((hopperMinecarts = WyHelper.getEntitiesNear(entity.func_180425_c(), entity.field_70170_p, 0.5, HopperMinecartEntity.class)).size() > 0) {
            shouldRemove = true;
        }
        if ((foxes = WyHelper.getEntitiesNear(entity.func_180425_c(), entity.field_70170_p, 1.5, FoxEntity.class)).size() > 0) {
            shouldRemove = true;
        }
        if (shouldRemove) {
            entity.func_70106_y();
            if (entity.func_200214_m() != null) {
                PlayerEntity thrower = entity.field_70170_p.func_217371_b(entity.func_200214_m());
                if (thrower != null) {
                    thrower.field_71071_by.func_70441_a(stack);
                } else {
                    worldData.removeDevilFruitInWorld(this);
                }
            } else {
                worldData.removeDevilFruitInWorld(this);
            }
        }
        return false;
    }

    private void applyCurseDeath(PlayerEntity player) {
        player.func_70097_a(ModDamageSource.DEVILS_CURSE, player.func_110138_aP());
    }

    public int getTier() {
        return this.tier;
    }

    public FruitType getType() {
        return this.type;
    }

    public String getDevilFruitName() {
        return this.name;
    }
}

