/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items.weapons;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ClimaTactItem
extends Item {
    private int damage = 1;
    private int level = 1;
    private Ingredient repairIngredient;
    private IItemPropertyGetter openProperty = (itemStack, world, livingEntity) -> {
        if (livingEntity == null) {
            return 0.0f;
        }
        boolean mainHandFlag = livingEntity.func_184614_ca() == itemStack;
        return mainHandFlag ? 1.0f : 0.0f;
    };

    public ClimaTactItem(int damage, int level, int maxDamage) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.WEAPONS).func_200917_a(1).func_200915_b(maxDamage));
        this.func_185043_a(new ResourceLocation("open"), this.openProperty);
        this.damage = damage;
        this.level = level;
    }

    public String checkCharge(ItemStack itemStack) {
        StringBuilder sb = new StringBuilder();
        if (!WyHelper.isNullOrEmpty(itemStack.func_196082_o().func_74779_i("firstSlot"))) {
            sb.append(itemStack.func_196082_o().func_74779_i("firstSlot"));
        }
        if (!WyHelper.isNullOrEmpty(itemStack.func_196082_o().func_74779_i("secondSlot"))) {
            sb.append(itemStack.func_196082_o().func_74779_i("secondSlot"));
        }
        if (!WyHelper.isNullOrEmpty(itemStack.func_196082_o().func_74779_i("thirdSlot"))) {
            sb.append(itemStack.func_196082_o().func_74779_i("thirdSlot"));
        }
        return sb.toString();
    }

    public void chargeWeatherBall(ItemStack itemStack, String ball) {
        if (WyHelper.isNullOrEmpty(itemStack.func_196082_o().func_74779_i("firstSlot"))) {
            itemStack.func_196082_o().func_74778_a("firstSlot", ball);
        } else if (WyHelper.isNullOrEmpty(itemStack.func_196082_o().func_74779_i("secondSlot"))) {
            itemStack.func_196082_o().func_74778_a("secondSlot", ball);
        } else if (WyHelper.isNullOrEmpty(itemStack.func_196082_o().func_74779_i("thirdSlot"))) {
            itemStack.func_196082_o().func_74778_a("thirdSlot", ball);
        }
    }

    public void emptyCharge(ItemStack itemStack) {
        itemStack.func_196082_o().func_74778_a("firstSlot", "");
        itemStack.func_196082_o().func_74778_a("secondSlot", "");
        itemStack.func_196082_o().func_74778_a("thirdSlot", "");
    }

    public void setDamageModifier(ItemStack stack, double multiplier) {
        stack.func_196082_o().func_74780_a("multiplier", multiplier);
    }

    public void setCharged(ItemStack stack, boolean flag) {
        stack.func_196082_o().func_74757_a("isCharged", flag);
    }

    public boolean isCharged(ItemStack stack) {
        return stack.func_196082_o().func_74767_n("isCharged");
    }

    public int getLevel() {
        return this.level;
    }

    public <T extends ClimaTactItem> T setRepairIngredient(Ingredient ingredient) {
        this.repairIngredient = ingredient;
        return (T)((Object)this);
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            double multiplier = stack.func_196082_o().func_74769_h("multiplier");
            if (multiplier <= 0.0) {
                multiplier = 1.0;
            }
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.damage * multiplier, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Speed modifier", -2.8, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.repairIngredient.test(repair) || super.func_82789_a(toRepair, repair);
    }
}

