/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IObtainItemObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncQuestDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class CSyncQuestDataPacket {
    private INBT data;

    public CSyncQuestDataPacket() {
    }

    public CSyncQuestDataPacket(IQuestData props) {
        this.data = new CompoundNBT();
        this.data = QuestDataCapability.INSTANCE.getStorage().writeNBT(QuestDataCapability.INSTANCE, (Object)props, null);
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150786_a((CompoundNBT)this.data);
    }

    public static CSyncQuestDataPacket decode(PacketBuffer buffer) {
        CSyncQuestDataPacket msg = new CSyncQuestDataPacket();
        msg.data = buffer.func_150793_b();
        return msg;
    }

    public static void handle(CSyncQuestDataPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IQuestData props = QuestDataCapability.get((PlayerEntity)player);
                QuestDataCapability.INSTANCE.getStorage().readNBT(QuestDataCapability.INSTANCE, (Object)props, null, message.data);
                for (Quest quest : props.getInProgressQuests()) {
                    if (quest == null) continue;
                    for (Objective obj : quest.getObjectives()) {
                        if (obj == null || !(obj instanceof IObtainItemObjective)) continue;
                        IObtainItemObjective itemQuest = (IObtainItemObjective)((Object)obj);
                        for (ItemStack stack : player.field_71071_by.field_70462_a) {
                            if (!itemQuest.checkItem(stack)) continue;
                            obj.alterProgress(stack.func_190916_E());
                        }
                    }
                }
                WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

