/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class CRemoveAbilityPacket {
    private int slot;

    public CRemoveAbilityPacket() {
    }

    public CRemoveAbilityPacket(int id) {
        this.slot = id;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.slot);
    }

    public static CRemoveAbilityPacket decode(PacketBuffer buffer) {
        CRemoveAbilityPacket msg = new CRemoveAbilityPacket();
        msg.slot = buffer.readInt();
        return msg;
    }

    public static void handle(CRemoveAbilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
                Object ability = abilityDataProps.getEquippedAbility(message.slot);
                if (ability == null) {
                    return;
                }
                if (ability instanceof ContinuousAbility && ((ContinuousAbility)((Object)((Object)ability))).isContinuous()) {
                    ((ContinuousAbility)((Object)((Object)ability))).stopContinuity((PlayerEntity)player);
                } else if (ability instanceof ChargeableAbility && ((ChargeableAbility)((Object)((Object)ability))).isCharging()) {
                    ((ChargeableAbility)((Object)((Object)ability))).stopCharging((PlayerEntity)player);
                } else if (((Ability)((Object)((Object)ability))).isOnCooldown()) {
                    ((Ability)((Object)((Object)ability))).stopCooldown((PlayerEntity)player);
                }
                abilityDataProps.setEquippedAbility(message.slot, null);
                if (abilityDataProps.getEquippedAbilitySlot((Ability)((Object)((Object)ability))) >= 0) {
                    WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((PlayerEntity)player, (Ability)((Object)((Object)ability))), (LivingEntity)player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

