/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PassiveAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class CTogglePassiveAbilityPacket {
    private String abilityName;
    private boolean flag;

    public CTogglePassiveAbilityPacket() {
    }

    public CTogglePassiveAbilityPacket(Ability ability, boolean flag) {
        this.abilityName = WyHelper.getResourceName(ability.getName());
        this.flag = flag;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.abilityName.length());
        buffer.func_211400_a(this.abilityName, this.abilityName.length());
        buffer.writeBoolean(this.flag);
    }

    public static CTogglePassiveAbilityPacket decode(PacketBuffer buffer) {
        CTogglePassiveAbilityPacket msg = new CTogglePassiveAbilityPacket();
        int len = buffer.readInt();
        msg.abilityName = buffer.func_150789_c(len);
        msg.flag = buffer.readBoolean();
        return msg;
    }

    public static void handle(CTogglePassiveAbilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                Ability ability;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
                Ability unlockedAbility = abilityDataProps.getUnlockedAbility(ability = ((Ability)GameRegistry.findRegistry(Ability.class).getValue(new ResourceLocation("mineminenomi", message.abilityName))).create());
                if (unlockedAbility instanceof PassiveAbility) {
                    PassiveAbility passive = (PassiveAbility)unlockedAbility;
                    passive.setPause(message.flag);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

