/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.abilities.doa.AirDoorAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ZoanAbility;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.events.passives.DoaPassiveEvents;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class CUseAbilityPacket {
    private int slot;

    public CUseAbilityPacket() {
    }

    public CUseAbilityPacket(int slot) {
        this.slot = slot;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.slot);
    }

    public static CUseAbilityPacket decode(PacketBuffer buffer) {
        CUseAbilityPacket msg = new CUseAbilityPacket();
        msg.slot = buffer.readInt();
        return msg;
    }

    public static void handle(CUseAbilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                player.field_70170_p.func_217381_Z().func_76320_a("abilityUse");
                IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
                Object abl = abilityDataProps.getEquippedAbility(message.slot);
                if (abl == null || player.func_175149_v() || !((Ability)((Object)((Object)abl))).canUse((PlayerEntity)player)) {
                    return;
                }
                try {
                    if (!(abl instanceof AirDoorAbility) && DoaPassiveEvents.isInsideDoor((PlayerEntity)player)) {
                        return;
                    }
                    if (abl instanceof ChargeableAbility && ((Ability)((Object)((Object)abl))).isCharging() && !((ChargeableAbility)((Object)((Object)abl))).isCancelable()) {
                        return;
                    }
                    if (abl instanceof ContinuousAbility && !((Ability)((Object)((Object)abl))).isContinuous() && !(abl instanceof IParallelContinuousAbility)) {
                        for (Ability ability : abilityDataProps.getEquippedAbilities()) {
                            if (!(ability instanceof ContinuousAbility) || !ability.isContinuous() || ability instanceof IParallelContinuousAbility) continue;
                            if (CommonConfig.INSTANCE.getStopContinuousAbility()) {
                                ((ContinuousAbility)ability).stopContinuity((PlayerEntity)player);
                                continue;
                            }
                            return;
                        }
                    }
                    if (abl instanceof ZoanAbility && !((Ability)((Object)((Object)abl))).isContinuous()) {
                        for (Ability ability : abilityDataProps.getEquippedAbilities()) {
                            if (!(ability instanceof ZoanAbility) || !ability.isContinuous()) continue;
                            if (CommonConfig.INSTANCE.getStopContinuousAbility()) {
                                ((ZoanAbility)ability).stopContinuity((PlayerEntity)player);
                                continue;
                            }
                            return;
                        }
                    }
                    ((Ability)((Object)((Object)abl))).use((PlayerEntity)player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ((Ability)((Object)((Object)abl))).startCooldown((PlayerEntity)player);
                }
                player.field_70170_p.func_217381_Z().func_76319_b();
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

