/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.challenge;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncChallengeDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class CResetChallengesPacket {
    private String category;

    public CResetChallengesPacket() {
    }

    public CResetChallengesPacket(String category) {
        this.category = category;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.category.length());
        buffer.func_180714_a(this.category);
    }

    public static CResetChallengesPacket decode(PacketBuffer buffer) {
        CResetChallengesPacket msg = new CResetChallengesPacket();
        int len = buffer.readInt();
        msg.category = buffer.func_150789_c(len);
        return msg;
    }

    public static void handle(CResetChallengesPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                if (!CommonConfig.INSTANCE.isReChallengesEnabled()) {
                    return;
                }
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IChallengesData props = ChallengesDataCapability.get((PlayerEntity)player);
                List<Challenge> challenges = props.getGroupedChallenges().get(message.category);
                for (Challenge ch : challenges) {
                    ch.setComplete(false);
                }
                WyNetwork.sendTo(new SSyncChallengeDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

