/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ui;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenCharacterCreatorScreenPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenPlayerScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class COpenPlayerScreenPacket {
    public void encode(PacketBuffer buffer) {
    }

    public static COpenPlayerScreenPacket decode(PacketBuffer buffer) {
        COpenPlayerScreenPacket msg = new COpenPlayerScreenPacket();
        return msg;
    }

    public static void handle(COpenPlayerScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
                if (!(entityProps.hasRace() && entityProps.hasFaction() && entityProps.hasFightingStyle())) {
                    boolean hasRandomizedRace = CommonConfig.INSTANCE.getRaceRandomizer();
                    WyNetwork.sendTo(new SOpenCharacterCreatorScreenPacket(hasRandomizedRace), (PlayerEntity)player);
                } else {
                    boolean hasQuests = CommonConfig.INSTANCE.isQuestsEnabled();
                    boolean hasChallenges = CommonConfig.INSTANCE.isChallengesEnabled();
                    WyNetwork.sendTo(new SOpenPlayerScreenPacket(hasQuests, hasChallenges), (PlayerEntity)player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

