/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class SAnimeScreamPacket {
    private int entityId;
    private String message;

    public SAnimeScreamPacket() {
    }

    public SAnimeScreamPacket(int entityId, String message) {
        this.entityId = entityId;
        this.message = message;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.message.length());
        buffer.func_211400_a(this.message, this.message.length());
    }

    public static SAnimeScreamPacket decode(PacketBuffer buffer) {
        SAnimeScreamPacket msg = new SAnimeScreamPacket();
        msg.entityId = buffer.readInt();
        int len = buffer.readInt();
        msg.message = buffer.func_150789_c(len);
        return msg;
    }

    public static void handle(SAnimeScreamPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SAnimeScreamPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof PlayerEntity)) {
                return;
            }
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("<" + target.func_145748_c_().func_150254_d() + "> " + message.message.toUpperCase()));
        }
    }
}

