/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.artofweather;

import java.awt.Color;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ChargedWeatherBallParticleEffect
extends ParticleEffect {
    private float red;
    private float green;
    private float blue;
    private ParticleType<GenericParticleData> particle;

    public ChargedWeatherBallParticleEffect(Color color, ParticleType<GenericParticleData> particle) {
        this.red = (float)color.getRed() / 255.0f;
        this.green = (float)color.getGreen() / 255.0f;
        this.blue = (float)color.getBlue() / 255.0f;
        this.particle = particle;
    }

    @Override
    public void spawn(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        for (int i = 0; i < 10; ++i) {
            double offsetX = WyHelper.randomDouble() / 1.5;
            double offsetY = WyHelper.randomDouble() / 1.5;
            double offsetZ = WyHelper.randomDouble() / 1.5;
            GenericParticleData data = new GenericParticleData(this.particle);
            data.setLife(4);
            data.setSize(2.0f);
            data.setMotion(0.0, 0.02, 0.0);
            data.setColor(this.red, this.green, this.blue);
            WyHelper.spawnParticles(data, (ServerWorld)world, posX + offsetX, posY + 1.0 + offsetY, posZ + offsetZ);
        }
    }
}

