/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.horu;

import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WinkExplosionEffect
extends ParticleEffect {
    private int explosionSize;

    public WinkExplosionEffect() {
        this(2);
    }

    public WinkExplosionEffect(int explosionSize) {
        this.explosionSize = explosionSize;
    }

    @Override
    public void spawn(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        for (int i = 0; i < this.explosionSize * 2; ++i) {
            double x = posX + WyHelper.randomWithRange(-this.explosionSize / 2, this.explosionSize / 2) + WyHelper.randomDouble();
            double y = posY + WyHelper.randomDouble();
            double z = posZ + WyHelper.randomWithRange(-this.explosionSize / 2, this.explosionSize / 2) + WyHelper.randomDouble();
            motionX = WyHelper.randomWithRange(-3, 3) + WyHelper.randomDouble();
            motionY = WyHelper.randomWithRange(-3, 3) + WyHelper.randomDouble();
            motionZ = WyHelper.randomWithRange(-3, 3) + WyHelper.randomDouble();
            double middlePoint = 0.5 / (5.0 / (double)this.explosionSize + 0.1);
            motionX *= (middlePoint *= WyHelper.randomDouble() * 2.0 + (double)0.3f) / 2.0;
            motionY *= middlePoint / 2.0;
            motionZ *= middlePoint / 2.0;
            GenericParticleData data = new GenericParticleData(ModParticleTypes.HORU);
            data.setLife(20);
            data.setSize(6.0f);
            data.setMotion(motionX, motionY, motionZ);
            WyHelper.spawnParticles(data, (ServerWorld)world, x, y + 1.0, z);
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197627_t, (ServerWorld)world, x, y, z);
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197598_I, (ServerWorld)world, posX, posY + 1.0, posZ);
        }
    }
}

