/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.brawler;

import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import xyz.pixelatedw.mineminenomi.abilities.brawler.HakaiHoAbility;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.ObtainItemObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.SharedKillChecks;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.client.CSyncAbilityDataPacket;

public class BrawlerTrial04Quest
extends Quest {
    private static final Predicate<ItemStack> IMPACT_DIAL_CHECK = itemStack -> itemStack.func_77973_b() == ModBlocks.IMPACT_DIAL.func_199767_j();
    private static final KillEntityObjective.ICheckKill DISTANCE_CHECK = (player, target, source) -> {
        boolean isProj = source.func_76364_f() instanceof CannonBallProjectile;
        boolean hasDistance = player.func_70032_d((Entity)target) >= 30.0f;
        return isProj && hasDistance;
    };
    private Objective objective01 = new ObtainItemObjective("Collect %s gunpowder", 30, Items.field_151016_H);
    private Objective objective02 = new ObtainItemObjective("Collect %s impact dials", 5, IMPACT_DIAL_CHECK);
    private Objective objective03 = new KillEntityObjective("Kill %s enemies from at least 30 blocks away using Genkotsu Meteor", 5, SharedKillChecks.HAS_BRALWER_HAND_CHECK.and(DISTANCE_CHECK)).addRequirements(this.objective01, this.objective02);

    public BrawlerTrial04Quest() {
        super("brawler_trial_04", "Trial: Hakai Ho");
        this.addRequirement(ModQuests.BRAWLER_TRIAL_03);
        this.addObjectives(this.objective01, this.objective02, this.objective03);
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        if (!this.removeQuestItem(player, Items.field_151016_H, 30)) {
            return false;
        }
        if (!this.removeQuestItem(player, ModBlocks.IMPACT_DIAL.func_199767_j(), 5)) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(HakaiHoAbility.INSTANCE);
        WyNetwork.sendToServer(new CSyncAbilityDataPacket(props));
        return true;
    }
}

