/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class LavaVisionFluidRenderer
extends FluidBlockRenderer {
    private final TextureAtlasSprite[] atlasSpritesLava = new TextureAtlasSprite[2];
    private final TextureAtlasSprite[] atlasSpritesWater = new TextureAtlasSprite[2];

    protected void func_178268_a() {
        this.atlasSpritesLava[0] = Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(Blocks.field_150353_l.func_176223_P()).func_177554_e();
        this.atlasSpritesLava[1] = ModelBakery.field_207766_d.func_229314_c_();
        this.atlasSpritesWater[0] = Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(Blocks.field_150355_j.func_176223_P()).func_177554_e();
        this.atlasSpritesWater[1] = ModelBakery.field_207768_f.func_229314_c_();
    }

    private static boolean isAdjacentFluidSameAs(IBlockReader worldIn, BlockPos pos, Direction side, IFluidState state) {
        BlockPos blockpos = pos.func_177972_a(side);
        IFluidState ifluidstate = worldIn.func_204610_c(blockpos);
        return ifluidstate.func_206886_c().func_207187_a(state.func_206886_c());
    }

    private static boolean isNeighbourSideCovered(IBlockReader reader, BlockPos pos, Direction face, float heightIn) {
        BlockPos blockpos = pos.func_177972_a(face);
        BlockState blockstate = reader.func_180495_p(blockpos);
        if (blockstate.func_200132_m()) {
            VoxelShape voxelshape = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)heightIn, (double)1.0);
            VoxelShape voxelshape1 = blockstate.func_196951_e(reader, blockpos);
            return VoxelShapes.func_197875_a((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (Direction)face);
        }
        return false;
    }

    public boolean func_228796_a_(ILightReader lightReaderIn, BlockPos posIn, IVertexBuilder vertexBuilderIn, IFluidState fluidStateIn) {
        float f12;
        boolean flag6;
        boolean flag = fluidStateIn.func_206884_a(FluidTags.field_206960_b);
        TextureAtlasSprite[] atextureatlassprite = ForgeHooksClient.getFluidSprites((ILightReader)lightReaderIn, (BlockPos)posIn, (IFluidState)fluidStateIn);
        int i = fluidStateIn.func_206886_c().getAttributes().getColor(lightReaderIn, posIn);
        float alpha = flag ? 0.5f : (float)(i >> 24 & 0xFF) / 255.0f;
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        boolean flag1 = !LavaVisionFluidRenderer.isAdjacentFluidSameAs((IBlockReader)lightReaderIn, posIn, Direction.UP, fluidStateIn);
        boolean flag2 = !LavaVisionFluidRenderer.isAdjacentFluidSameAs((IBlockReader)lightReaderIn, posIn, Direction.DOWN, fluidStateIn) && !LavaVisionFluidRenderer.isNeighbourSideCovered((IBlockReader)lightReaderIn, posIn, Direction.DOWN, 0.8888889f);
        boolean flag3 = !LavaVisionFluidRenderer.isAdjacentFluidSameAs((IBlockReader)lightReaderIn, posIn, Direction.NORTH, fluidStateIn);
        boolean flag4 = !LavaVisionFluidRenderer.isAdjacentFluidSameAs((IBlockReader)lightReaderIn, posIn, Direction.SOUTH, fluidStateIn);
        boolean flag5 = !LavaVisionFluidRenderer.isAdjacentFluidSameAs((IBlockReader)lightReaderIn, posIn, Direction.WEST, fluidStateIn);
        boolean bl = flag6 = !LavaVisionFluidRenderer.isAdjacentFluidSameAs((IBlockReader)lightReaderIn, posIn, Direction.EAST, fluidStateIn);
        if (!(flag1 || flag2 || flag6 || flag5 || flag3 || flag4)) {
            return false;
        }
        boolean flag7 = false;
        float f7 = this.getFluidHeight((IBlockReader)lightReaderIn, posIn, fluidStateIn.func_206886_c());
        float f8 = this.getFluidHeight((IBlockReader)lightReaderIn, posIn.func_177968_d(), fluidStateIn.func_206886_c());
        float f9 = this.getFluidHeight((IBlockReader)lightReaderIn, posIn.func_177974_f().func_177968_d(), fluidStateIn.func_206886_c());
        float f10 = this.getFluidHeight((IBlockReader)lightReaderIn, posIn.func_177974_f(), fluidStateIn.func_206886_c());
        double d0 = posIn.func_177958_n() & 0xF;
        double d1 = posIn.func_177956_o() & 0xF;
        double d2 = posIn.func_177952_p() & 0xF;
        float f3 = f12 = flag2 ? 0.001f : 0.0f;
        if (flag1 && !LavaVisionFluidRenderer.isNeighbourSideCovered((IBlockReader)lightReaderIn, posIn, Direction.UP, Math.min(Math.min(f7, f8), Math.min(f9, f10)))) {
            float f20;
            float f16;
            float f19;
            float f15;
            float f18;
            float f14;
            float f17;
            float f13;
            flag7 = true;
            f7 -= 0.001f;
            f8 -= 0.001f;
            f9 -= 0.001f;
            f10 -= 0.001f;
            Vec3d vec3d = fluidStateIn.func_215673_c((IBlockReader)lightReaderIn, posIn);
            if (vec3d.field_72450_a == 0.0 && vec3d.field_72449_c == 0.0) {
                TextureAtlasSprite textureatlassprite1 = atextureatlassprite[0];
                f13 = textureatlassprite1.func_94214_a(0.0);
                f17 = textureatlassprite1.func_94207_b(0.0);
                f14 = f13;
                f18 = textureatlassprite1.func_94207_b(16.0);
                f15 = textureatlassprite1.func_94214_a(16.0);
                f19 = f18;
                f16 = f15;
                f20 = f17;
            } else {
                TextureAtlasSprite textureatlassprite = atextureatlassprite[1];
                float f21 = (float)MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) - 1.5707964f;
                float f22 = MathHelper.func_76126_a((float)f21) * 0.25f;
                float f23 = MathHelper.func_76134_b((float)f21) * 0.25f;
                float f24 = 8.0f;
                f13 = textureatlassprite.func_94214_a((double)(8.0f + (-f23 - f22) * 16.0f));
                f17 = textureatlassprite.func_94207_b((double)(8.0f + (-f23 + f22) * 16.0f));
                f14 = textureatlassprite.func_94214_a((double)(8.0f + (-f23 + f22) * 16.0f));
                f18 = textureatlassprite.func_94207_b((double)(8.0f + (f23 + f22) * 16.0f));
                f15 = textureatlassprite.func_94214_a((double)(8.0f + (f23 + f22) * 16.0f));
                f19 = textureatlassprite.func_94207_b((double)(8.0f + (f23 - f22) * 16.0f));
                f16 = textureatlassprite.func_94214_a((double)(8.0f + (f23 - f22) * 16.0f));
                f20 = textureatlassprite.func_94207_b((double)(8.0f + (-f23 - f22) * 16.0f));
            }
            float f43 = (f13 + f14 + f15 + f16) / 4.0f;
            float f44 = (f17 + f18 + f19 + f20) / 4.0f;
            float f45 = (float)atextureatlassprite[0].func_94211_a() / (atextureatlassprite[0].func_94212_f() - atextureatlassprite[0].func_94209_e());
            float f46 = (float)atextureatlassprite[0].func_94216_b() / (atextureatlassprite[0].func_94210_h() - atextureatlassprite[0].func_94206_g());
            float f47 = 4.0f / Math.max(f46, f45);
            f13 = MathHelper.func_219799_g((float)f47, (float)f13, (float)f43);
            f14 = MathHelper.func_219799_g((float)f47, (float)f14, (float)f43);
            f15 = MathHelper.func_219799_g((float)f47, (float)f15, (float)f43);
            f16 = MathHelper.func_219799_g((float)f47, (float)f16, (float)f43);
            f17 = MathHelper.func_219799_g((float)f47, (float)f17, (float)f44);
            f18 = MathHelper.func_219799_g((float)f47, (float)f18, (float)f44);
            f19 = MathHelper.func_219799_g((float)f47, (float)f19, (float)f44);
            f20 = MathHelper.func_219799_g((float)f47, (float)f20, (float)f44);
            int j = this.getCombinedAverageLight(lightReaderIn, posIn);
            this.vertex(vertexBuilderIn, d0 + 0.0, d1 + (double)f7, d2 + 0.0, f, f1, f2, alpha, f13, f17, j);
            this.vertex(vertexBuilderIn, d0 + 0.0, d1 + (double)f8, d2 + 1.0, f, f1, f2, alpha, f14, f18, j);
            this.vertex(vertexBuilderIn, d0 + 1.0, d1 + (double)f9, d2 + 1.0, f, f1, f2, alpha, f15, f19, j);
            this.vertex(vertexBuilderIn, d0 + 1.0, d1 + (double)f10, d2 + 0.0, f, f1, f2, alpha, f16, f20, j);
            if (fluidStateIn.func_205586_a((IBlockReader)lightReaderIn, posIn.func_177984_a())) {
                this.vertex(vertexBuilderIn, d0 + 0.0, d1 + (double)f7, d2 + 0.0, f, f1, f2, alpha, f13, f17, j);
                this.vertex(vertexBuilderIn, d0 + 1.0, d1 + (double)f10, d2 + 0.0, f, f1, f2, alpha, f16, f20, j);
                this.vertex(vertexBuilderIn, d0 + 1.0, d1 + (double)f9, d2 + 1.0, f, f1, f2, alpha, f15, f19, j);
                this.vertex(vertexBuilderIn, d0 + 0.0, d1 + (double)f8, d2 + 1.0, f, f1, f2, alpha, f14, f18, j);
            }
        }
        if (flag2) {
            float f34 = atextureatlassprite[0].func_94209_e();
            float f35 = atextureatlassprite[0].func_94212_f();
            float f37 = atextureatlassprite[0].func_94206_g();
            float f39 = atextureatlassprite[0].func_94210_h();
            int i1 = this.getCombinedAverageLight(lightReaderIn, posIn.func_177977_b());
            float f40 = 0.5f * f;
            float f41 = 0.5f * f1;
            float f42 = 0.5f * f2;
            this.vertex(vertexBuilderIn, d0, d1 + (double)f12, d2 + 1.0, f40, f41, f42, alpha, f34, f39, i1);
            this.vertex(vertexBuilderIn, d0, d1 + (double)f12, d2, f40, f41, f42, alpha, f34, f37, i1);
            this.vertex(vertexBuilderIn, d0 + 1.0, d1 + (double)f12, d2, f40, f41, f42, alpha, f35, f37, i1);
            this.vertex(vertexBuilderIn, d0 + 1.0, d1 + (double)f12, d2 + 1.0, f40, f41, f42, alpha, f35, f39, i1);
            flag7 = true;
        }
        for (int l = 0; l < 4; ++l) {
            boolean flag8;
            Direction direction;
            double d6;
            double d4;
            double d5;
            double d3;
            float f38;
            float f36;
            if (l == 0) {
                f36 = f7;
                f38 = f10;
                d3 = d0;
                d5 = d0 + 1.0;
                d4 = d2 + (double)0.001f;
                d6 = d2 + (double)0.001f;
                direction = Direction.NORTH;
                flag8 = flag3;
            } else if (l == 1) {
                f36 = f9;
                f38 = f8;
                d3 = d0 + 1.0;
                d5 = d0;
                d4 = d2 + 1.0 - (double)0.001f;
                d6 = d2 + 1.0 - (double)0.001f;
                direction = Direction.SOUTH;
                flag8 = flag4;
            } else if (l == 2) {
                f36 = f8;
                f38 = f7;
                d3 = d0 + (double)0.001f;
                d5 = d0 + (double)0.001f;
                d4 = d2 + 1.0;
                d6 = d2;
                direction = Direction.WEST;
                flag8 = flag5;
            } else {
                f36 = f10;
                f38 = f9;
                d3 = d0 + 1.0 - (double)0.001f;
                d5 = d0 + 1.0 - (double)0.001f;
                d4 = d2;
                d6 = d2 + 1.0;
                direction = Direction.EAST;
                flag8 = flag6;
            }
            if (!flag8 || LavaVisionFluidRenderer.isNeighbourSideCovered((IBlockReader)lightReaderIn, posIn, direction, Math.max(f36, f38))) continue;
            flag7 = true;
            BlockPos blockpos = posIn.func_177972_a(direction);
            TextureAtlasSprite textureatlassprite2 = atextureatlassprite[1];
            if (atextureatlassprite[2] != null && lightReaderIn.func_180495_p(blockpos).shouldDisplayFluidOverlay(lightReaderIn, blockpos, fluidStateIn)) {
                textureatlassprite2 = atextureatlassprite[2];
            }
            float f48 = textureatlassprite2.func_94214_a(0.0);
            float f49 = textureatlassprite2.func_94214_a(8.0);
            float f50 = textureatlassprite2.func_94207_b((double)((1.0f - f36) * 16.0f * 0.5f));
            float f28 = textureatlassprite2.func_94207_b((double)((1.0f - f38) * 16.0f * 0.5f));
            float f29 = textureatlassprite2.func_94207_b(8.0);
            int k = this.getCombinedAverageLight(lightReaderIn, blockpos);
            float f30 = l < 2 ? 0.8f : 0.6f;
            float f31 = 1.0f * f30 * f;
            float f32 = 1.0f * f30 * f1;
            float f33 = 1.0f * f30 * f2;
            this.vertex(vertexBuilderIn, d3, d1 + (double)f36, d4, f31, f32, f33, alpha, f48, f50, k);
            this.vertex(vertexBuilderIn, d5, d1 + (double)f38, d6, f31, f32, f33, alpha, f49, f28, k);
            this.vertex(vertexBuilderIn, d5, d1 + (double)f12, d6, f31, f32, f33, alpha, f49, f29, k);
            this.vertex(vertexBuilderIn, d3, d1 + (double)f12, d4, f31, f32, f33, alpha, f48, f29, k);
            if (textureatlassprite2 == atextureatlassprite[2]) continue;
            this.vertex(vertexBuilderIn, d3, d1 + (double)f12, d4, f31, f32, f33, alpha, f48, f29, k);
            this.vertex(vertexBuilderIn, d5, d1 + (double)f12, d6, f31, f32, f33, alpha, f49, f29, k);
            this.vertex(vertexBuilderIn, d5, d1 + (double)f38, d6, f31, f32, f33, alpha, f49, f28, k);
            this.vertex(vertexBuilderIn, d3, d1 + (double)f36, d4, f31, f32, f33, alpha, f48, f50, k);
        }
        return flag7;
    }

    private void vertex(IVertexBuilder vertexBuilderIn, double x, double y, double z, float red, float green, float blue, float alpha, float u, float v, int packedLight) {
        vertexBuilderIn.func_225582_a_(x, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_227886_a_(packedLight).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private int getCombinedAverageLight(ILightReader lightReaderIn, BlockPos posIn) {
        int i = WorldRenderer.func_228421_a_((ILightReader)lightReaderIn, (BlockPos)posIn);
        int j = WorldRenderer.func_228421_a_((ILightReader)lightReaderIn, (BlockPos)posIn.func_177984_a());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return Math.max(k, l) | Math.max(i1, j1) << 16;
    }

    private float getFluidHeight(IBlockReader reader, BlockPos pos, Fluid fluidIn) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < 4; ++j) {
            BlockPos blockpos = pos.func_177982_a(-(j & 1), 0, -(j >> 1 & 1));
            if (reader.func_204610_c(blockpos.func_177984_a()).func_206886_c().func_207187_a(fluidIn)) {
                return 1.0f;
            }
            IFluidState ifluidstate = reader.func_204610_c(blockpos);
            if (ifluidstate.func_206886_c().func_207187_a(fluidIn)) {
                float f1 = ifluidstate.func_215679_a(reader, blockpos);
                if (f1 >= 0.8f) {
                    f += f1 * 10.0f;
                    i += 10;
                    continue;
                }
                f += f1;
                ++i;
                continue;
            }
            if (reader.func_180495_p(blockpos).func_185904_a().func_76220_a()) continue;
            ++i;
        }
        return f / (float)i;
    }
}

