/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;

public class LightningEntityRenderer
extends EntityRenderer<LightningEntity> {
    public LightningEntityRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(LightningEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStack.func_227860_a_();
        LightningEntityRenderer.renderLightning(entity, partialTicks, matrixStack, bufferIn, packedLightIn);
        matrixStack.func_227865_b_();
    }

    public static void renderLightning(LightningEntity entity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (0 > entity.getSegments()) {
            return;
        }
        Random random = new Random(entity.seed);
        int angle = entity.getAngle();
        int segments = entity.getSegments();
        float length = entity.getLength() * Math.min(((float)entity.field_70173_aa + partialTicks) / 2.0f, 1.0f);
        float size = entity.getSize();
        int branches = entity.getBranches();
        float maxDistance = entity.getLength() / (float)segments;
        Color rgb = new Color(entity.getColor());
        float[] arr = new float[segments];
        int targetNumber = (int)((float)segments * Math.min(((float)entity.field_70173_aa + partialTicks) / 2.0f, 1.0f));
        int renderTime = entity.getAliveTicks() / 2;
        float alpha = entity.field_70173_aa < renderTime ? 0.3f : Math.max(0.3f * (1.0f - ((float)(entity.field_70173_aa - renderTime) + partialTicks) / (float)renderTime), 0.0f);
        for (int segment = 0; segment < arr.length; ++segment) {
            arr[segment] = segment == targetNumber ? length - maxDistance * (float)segment : maxDistance;
        }
        float[] offsetsY = new float[segments];
        float[] offsetsX = new float[segments];
        IVertexBuilder vertex = bufferIn.getBuffer(entity.getEnergyEffect() ? ModRenderTypes.ENERGY : ModRenderTypes.SOLID);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(entity.func_195046_g(partialTicks)));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(entity.func_195050_f(partialTicks)));
        matrixStack.func_227861_a_(0.0, 0.0, 0.1);
        for (int i = 0; i < branches; ++i) {
            int j;
            float lastOffsetY = 0.0f;
            float lastOffsetX = 0.0f;
            for (j = 0; j < segments; ++j) {
                offsetsY[j] = lastOffsetY;
                offsetsX[j] = lastOffsetX;
                lastOffsetY = (float)((double)lastOffsetY + Math.sin(Math.toRadians((float)random.nextInt(angle) - (float)angle / 2.0f)));
                lastOffsetX = (float)((double)lastOffsetX + Math.sin(Math.toRadians((float)random.nextInt(angle) - (float)angle / 2.0f)));
            }
            for (j = 0; j < segments; ++j) {
                float y = offsetsY[j];
                float x = offsetsX[j];
                for (int depth = 1; depth < 4; ++depth) {
                    float endX;
                    float depthY = size / 2.0f + (float)depth * size;
                    float depthZ = size / 2.0f + (float)depth * size;
                    float endY = j == segments - 1 ? y : offsetsY[j + 1];
                    float f = endX = j == segments - 1 ? x : offsetsX[j + 1];
                    if (j > targetNumber) continue;
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, false, false, true, false, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, true, false, true, true, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, true, true, false, true, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, false, true, false, false, maxDistance, arr[j], packedLightIn);
                }
            }
        }
    }

    private static void drawQuad(Matrix4f matrix4f, IVertexBuilder vertex, float startY, float startX, int segmentIndex, float endY, float endX, float red, float green, float blue, float alpha, float firstOffset, float secondOffset, boolean negativeOffset, boolean bl2, boolean bl3, boolean bl4, float segmentLength, float segmentLengthAdded, int light) {
        vertex.func_227888_a_(matrix4f, startX + (bl2 ? secondOffset : -secondOffset), startY + (negativeOffset ? secondOffset : -secondOffset), (float)segmentIndex * segmentLength).func_227885_a_(red / 255.0f, green / 255.0f, blue / 255.0f, alpha).func_227886_a_(light).func_181675_d();
        vertex.func_227888_a_(matrix4f, endX + (bl2 ? firstOffset : -firstOffset), endY + (negativeOffset ? firstOffset : -firstOffset), (float)segmentIndex * segmentLength + segmentLengthAdded).func_227885_a_(red / 255.0f, green / 255.0f, blue / 255.0f, alpha).func_227886_a_(light).func_181675_d();
        vertex.func_227888_a_(matrix4f, endX + (bl4 ? firstOffset : -firstOffset), endY + (bl3 ? firstOffset : -firstOffset), (float)segmentIndex * segmentLength + segmentLengthAdded).func_227885_a_(red / 255.0f, green / 255.0f, blue / 255.0f, alpha).func_227886_a_(light).func_181675_d();
        vertex.func_227888_a_(matrix4f, startX + (bl4 ? secondOffset : -secondOffset), startY + (bl3 ? secondOffset : -secondOffset), (float)segmentIndex * segmentLength).func_227885_a_(red / 255.0f, green / 255.0f, blue / 255.0f, alpha).func_227886_a_(light).func_181675_d();
    }

    public static void renderLightning(Entity entity, long seed, float len, float pitch, float yaw, Color rgb, float alpha, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        float partialTicks = 1.0f;
        Random random = new Random(seed);
        int angle = 90;
        int segments = 6;
        float size = 0.02f;
        int branches = 4;
        float length = len * Math.min(((float)entity.field_70173_aa + partialTicks) / 2.0f, 1.0f);
        float maxDistance = length / (float)segments;
        float[] arr = new float[segments];
        int targetNumber = (int)((float)segments * Math.min(((float)entity.field_70173_aa + partialTicks) / 2.0f, 1.0f));
        for (int segment = 0; segment < arr.length; ++segment) {
            arr[segment] = segment == targetNumber ? length - maxDistance * (float)segment : maxDistance;
        }
        float[] offsetsY = new float[segments];
        float[] offsetsX = new float[segments];
        IVertexBuilder vertex = bufferIn.getBuffer(ModRenderTypes.ENERGY);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(pitch));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(yaw));
        for (int i = 0; i < branches; ++i) {
            int j;
            float lastOffsetY = 0.0f;
            float lastOffsetX = 0.0f;
            for (j = 0; j < segments; ++j) {
                offsetsY[j] = lastOffsetY;
                offsetsX[j] = lastOffsetX;
                lastOffsetY = (float)((double)lastOffsetY + Math.sin(Math.toRadians((float)random.nextInt(angle) - (float)angle / 2.0f)));
                lastOffsetX = (float)((double)lastOffsetX + Math.sin(Math.toRadians((float)random.nextInt(angle) - (float)angle / 2.0f)));
            }
            for (j = 0; j < segments; ++j) {
                float y = offsetsY[j];
                float x = offsetsX[j];
                for (int depth = 1; depth < 4; ++depth) {
                    float endX;
                    float depthY = size / 2.0f + (float)depth * size;
                    float depthZ = size / 2.0f + (float)depth * size;
                    float endY = j == segments - 1 ? y : offsetsY[j + 1];
                    float f = endX = j == segments - 1 ? x : offsetsX[j + 1];
                    if (j > targetNumber) continue;
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, false, false, true, false, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, true, false, true, true, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, true, true, false, true, maxDistance, arr[j], packedLightIn);
                    LightningEntityRenderer.drawQuad(matrix4f, vertex, y, x, j, endY, endX, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha, depthY, depthZ, false, true, false, false, maxDistance, arr[j], packedLightIn);
                }
            }
        }
    }

    public ResourceLocation getEntityTexture(LightningEntity entity) {
        return null;
    }

    public boolean shouldRender(LightningEntity livingEntityIn, ClippingHelperImpl camera, double camX, double camY, double camZ) {
        return true;
    }

    public static class Factory
    implements IRenderFactory<LightningEntity> {
        public EntityRenderer<? super LightningEntity> createRenderFor(EntityRendererManager manager) {
            return new LightningEntityRenderer(manager);
        }
    }
}

