/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.entities.zoans.partial;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.api.ZoanMorphModel;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.models.entities.zoans.partial.MinkLionPartialModel;

public class MinkLionPartialRenderer<T extends AbstractClientPlayerEntity, M extends ZoanMorphModel>
extends PlayerRenderer {
    private MinkLionPartialModel model = new MinkLionPartialModel();
    private ResourceLocation texture = new ResourceLocation("mineminenomi", "textures/models/zoanmorph/mink_lion.png");

    public MinkLionPartialRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void func_225623_a_(AbstractClientPlayerEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        Direction direction;
        boolean shouldSit;
        matrixStack.func_227860_a_();
        ((PlayerModel)this.field_77045_g).field_217112_c = this.func_77040_d((LivingEntity)entity, partialTicks);
        ((PlayerModel)this.field_77045_g).field_217113_d = shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        ((PlayerModel)this.field_77045_g).field_217114_e = entity.func_70631_g_();
        float headYawOffset = MathHelper.func_219805_h((float)partialTicks, (float)entity.field_70760_ar, (float)entity.field_70761_aq);
        float headYaw = MathHelper.func_219805_h((float)partialTicks, (float)entity.field_70758_at, (float)entity.field_70759_as);
        float netHeadYaw = headYaw - headYawOffset;
        if (shouldSit && entity.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.func_184187_bx();
            headYawOffset = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            netHeadYaw = headYaw - headYawOffset;
            float f3 = MathHelper.func_76142_g((float)netHeadYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            headYawOffset = headYaw - f3;
            if (f3 * f3 > 2500.0f) {
                headYawOffset += f3 * 0.2f;
            }
            netHeadYaw = headYaw - headYawOffset;
        }
        float headPitch = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70127_C, (float)entity.field_70125_A);
        if (entity.func_213283_Z() == Pose.SLEEPING && (direction = entity.func_213376_dz()) != null) {
            float f4 = entity.func_213307_e(Pose.STANDING) - 0.1f;
            matrixStack.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float ageInTicks = this.func_77044_a((LivingEntity)entity, partialTicks);
        this.func_225621_a_(entity, matrixStack, ageInTicks, headYawOffset, partialTicks);
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.func_225620_a_(entity, matrixStack, partialTicks);
        matrixStack.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && entity.func_70089_S()) {
            limbSwingAmount = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_184618_aE, (float)entity.field_70721_aZ);
            limbSwing = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
            if (entity.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        RenderType renderType = ModRenderTypes.getZoanRenderType(this.texture);
        this.model.field_228270_o_ = entity.func_213453_ef();
        this.model.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.model.func_225598_a_(matrixStack, buffer.getBuffer(renderType), packedLight, packedLight, packedLight, entity.field_70177_z, partialTicks, packedLight);
        matrixStack.func_227865_b_();
    }

    public static class Factory<T extends PlayerEntity>
    implements IRenderFactory<T> {
        public EntityRenderer<? super T> createRenderFor(EntityRendererManager manager) {
            return new MinkLionPartialRenderer(manager);
        }
    }
}

