/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRoger;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.client.crew.CKickFromCrewPacket;
import xyz.pixelatedw.mineminenomi.packets.client.crew.CLeaveCrewPacket;
import xyz.pixelatedw.mineminenomi.screens.JollyRogerCreatorScreen;
import xyz.pixelatedw.mineminenomi.screens.extra.NoTextureButton;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class CrewDetailsScreen
extends Screen {
    private PlayerEntity player;
    private ExtendedWorldData worldProps;
    private JollyRoger jollyRoger;
    private Crew crew;

    public CrewDetailsScreen() {
        super((ITextComponent)new StringTextComponent(""));
        this.minecraft = Minecraft.func_71410_x();
        this.player = this.minecraft.field_71439_g;
        this.worldProps = ExtendedWorldData.get(this.player.field_70170_p);
    }

    public void render(int x, int y, float f) {
        this.renderBackground();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = (this.width - 256) / 2;
        int posY = (this.height - 256) / 2;
        String nameString = I18n.func_135052_a((String)ModI18n.GUI_NAME, (Object[])new Object[0]);
        String jollyRogerString = I18n.func_135052_a((String)ModI18n.GUI_CREW_JOLLY_ROGER, (Object[])new Object[0]);
        String membersString = I18n.func_135052_a((String)ModI18n.GUI_CREW_MEMBERS, (Object[])new Object[0]);
        String crewActual = "";
        if (this.crew == null) {
            return;
        }
        crewActual = this.crew.getName();
        WyHelper.drawStringWithBorder(this.font, TextFormatting.BOLD + nameString + ": " + TextFormatting.RESET + crewActual, posX - 50, posY + 50, -1);
        WyHelper.drawStringWithBorder(this.font, TextFormatting.BOLD + jollyRogerString + ": ", posX - 50, posY + 70, -1);
        WyHelper.drawStringWithBorder(this.font, TextFormatting.BOLD + membersString + ": ", posX + 150, posY + 50, -1);
        int memPosY = posY + 70;
        for (Crew.Member member : this.crew.getMembers()) {
            String memberName = member.getUsername();
            if (memberName.length() >= 20) {
                memberName = memberName.substring(0, 20) + "...";
            }
            memberName = memberName + (member.isCaptain() ? " (" + I18n.func_135052_a((String)ModI18n.CREW_CAPTAIN, (Object[])new Object[0]) + ")" : "");
            WyHelper.drawStringWithBorder(this.font, memberName, posX + 150, memPosY, -1);
            memPosY += 20;
        }
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        double scale = 0.4;
        RenderSystem.translated((double)(posX - 110), (double)(posY + 15), (double)1.0);
        RenderSystem.translated((double)128.0, (double)128.0, (double)0.0);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        RenderSystem.translated((double)-128.0, (double)-128.0, (double)0.0);
        if (this.jollyRoger != null) {
            RendererHelper.drawPlayerJollyRoger(this.jollyRoger);
        }
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        super.render(x, y, f);
    }

    public void init() {
        this.children.clear();
        this.buttons.clear();
        this.crew = this.worldProps.getCrewWithMember(this.player.func_110124_au());
        if (this.crew == null) {
            return;
        }
        UUID captainUUID = this.crew.getCaptain().getUUID();
        PlayerEntity crewCaptain = this.minecraft.field_71441_e.func_217371_b(captainUUID);
        this.jollyRoger = this.crew.getJollyRoger();
        int posX = (this.width - 256) / 2 - 50;
        int posY = (this.height - 256) / 2;
        if (this.crew.getCaptain().getUUID().equals(this.player.func_110124_au())) {
            int idx = 0;
            for (Crew.Member member : this.crew.getMembers()) {
                if (member.isCaptain()) {
                    ++idx;
                    continue;
                }
                NoTextureButton kickButton = new NoTextureButton(posX + 180, posY + 68 + 20 * idx, 10, 10, "X", b -> {
                    WyNetwork.sendToServer(new CKickFromCrewPacket(member.getUUID()));
                    this.crew.removeMember(member.getUUID());
                    this.init();
                });
                kickButton.setOnHoverTextColor("#FF0000");
                this.addButton((Widget)kickButton);
                ++idx;
            }
        }
        this.addButton((Widget)new Button(posX += 80, posY + 210, 70, 20, I18n.func_135052_a((String)ModI18n.GUI_LEAVE, (Object[])new Object[0]), b -> {
            WyNetwork.sendToServer(new CLeaveCrewPacket());
            Minecraft.func_71410_x().func_147108_a(null);
        }));
        if (crewCaptain != null && this.player == crewCaptain) {
            this.addButton((Widget)new Button(posX += 80, posY + 210, 120, 20, I18n.func_135052_a((String)ModI18n.GUI_CHANGE_JOLLY_ROGER, (Object[])new Object[0]), b -> Minecraft.func_71410_x().func_147108_a((Screen)new JollyRogerCreatorScreen(false))));
        }
    }
}

