/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.packets.client.CRequestSyncQuestDataPacket;
import xyz.pixelatedw.mineminenomi.packets.client.CRequestSyncWorldDataPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ui.COpenChallengesScreenPacket;
import xyz.pixelatedw.mineminenomi.screens.CrewDetailsScreen;
import xyz.pixelatedw.mineminenomi.screens.QuestsTrackerScreen;
import xyz.pixelatedw.mineminenomi.screens.SelectHotbarAbilitiesScreen;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class PlayerStatsScreen
extends Screen {
    private final PlayerEntity player;
    private ExtendedWorldData worldProps;
    private IEntityStats entityStatsProps;
    private IDevilFruit devilFruitProps;
    private IChallengesData challengesProps;
    private final boolean hasQuests;
    private final boolean hasChallenges;

    public PlayerStatsScreen(boolean hasQuests, boolean hasChallenges) {
        super((ITextComponent)new StringTextComponent(""));
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.hasQuests = hasQuests;
        this.hasChallenges = hasChallenges;
        this.worldProps = ExtendedWorldData.get(this.player.field_70170_p);
    }

    public void render(int x, int y, float f) {
        String style;
        String race;
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = (this.width - 256) / 2;
        int posY = (this.height - 256) / 2;
        String colaLabel = I18n.func_135052_a((String)ModI18n.GUI_COLA, (Object[])new Object[0]);
        String dorikiLabel = I18n.func_135052_a((String)ModI18n.GUI_DORIKI, (Object[])new Object[0]);
        String factionLabel = I18n.func_135052_a((String)ModI18n.FACTION_NAME, (Object[])new Object[0]);
        String raceLabel = I18n.func_135052_a((String)ModI18n.RACE_NAME, (Object[])new Object[0]);
        String styleLabel = I18n.func_135052_a((String)ModI18n.STYLE_NAME, (Object[])new Object[0]);
        String faction = WyHelper.getResourceName(this.entityStatsProps.getFaction());
        if (WyHelper.isNullOrEmpty(faction)) {
            faction = "empty";
        }
        if (WyHelper.isNullOrEmpty(race = WyHelper.getResourceName(this.entityStatsProps.getRace().toLowerCase()))) {
            race = "empty";
        }
        if (WyHelper.isNullOrEmpty(style = WyHelper.getResourceName(this.entityStatsProps.getFightingStyle().toLowerCase()))) {
            style = "empty";
        }
        String actualRank = "";
        if (this.entityStatsProps.isMarine()) {
            FactionHelper.MarineRank marineRank = this.entityStatsProps.getMarineRank();
            actualRank = marineRank != null ? " - " + marineRank.getLocalizedName() : "";
        } else if (this.entityStatsProps.isRevolutionary()) {
            FactionHelper.RevolutionaryRank revoRank = this.entityStatsProps.getRevolutionaryRank();
            actualRank = revoRank != null ? " - " + revoRank.getLocalizedName() : "";
        }
        String factionActual = I18n.func_135052_a((String)("faction." + faction), (Object[])new Object[0]) + actualRank;
        String raceActual = I18n.func_135052_a((String)("race." + race), (Object[])new Object[0]);
        String styleActual = I18n.func_135052_a((String)("style." + style), (Object[])new Object[0]);
        if (this.entityStatsProps.isCyborg()) {
            WyHelper.drawStringWithBorder(this.font, TextFormatting.BOLD + colaLabel + ": " + TextFormatting.RESET + this.entityStatsProps.getCola() + " / " + this.entityStatsProps.getMaxCola(), posX - 50, posY + 50, -1);
        }
        WyHelper.drawStringWithBorder(this.font, TextFormatting.BOLD + dorikiLabel + ": " + TextFormatting.RESET + this.entityStatsProps.getDoriki(), posX - 50, posY + 70, -1);
        WyHelper.drawStringWithBorder(this.font, TextFormatting.BOLD + factionLabel + ": " + TextFormatting.RESET + factionActual, posX - 50, posY + 90, -1);
        WyHelper.drawStringWithBorder(this.font, TextFormatting.BOLD + raceLabel + ": " + TextFormatting.RESET + raceActual, posX - 50, posY + 110, -1);
        WyHelper.drawStringWithBorder(this.font, TextFormatting.BOLD + styleLabel + ": " + TextFormatting.RESET + styleActual, posX - 50, posY + 130, -1);
        if (this.entityStatsProps.getBelly() > 0L) {
            WyHelper.drawStringWithBorder(this.font, "" + this.entityStatsProps.getBelly(), posX + 215, posY + 72, -1);
            this.minecraft.field_71446_o.func_110577_a(ModResources.CURRENCIES);
            this.blit(posX + 190, posY + 60, 0, 32, 32, 64);
        }
        if (this.entityStatsProps.getExtol() > 0L) {
            WyHelper.drawStringWithBorder(this.font, "" + this.entityStatsProps.getExtol(), posX + 215, posY + 102, -1);
            this.minecraft.field_71446_o.func_110577_a(ModResources.CURRENCIES);
            this.blit(posX + 190, posY + 89, 34, 32, 64, 86);
        }
        if (!WyHelper.isNullOrEmpty(this.devilFruitProps.getDevilFruit())) {
            ItemStack yamiFruit = new ItemStack((IItemProvider)ModAbilities.YAMI_YAMI_NO_MI);
            if (this.devilFruitProps.hasDevilFruit(ModAbilities.YAMI_YAMI_NO_MI)) {
                boolean dual;
                ItemStack df = DevilFruitHelper.getDevilFruitItem(this.devilFruitProps.getDevilFruit());
                String dfKey = DevilFruitHelper.getDevilFruitKey((AkumaNoMiItem)df.func_77973_b());
                boolean bl = dual = this.devilFruitProps.hasYamiPower() && !dfKey.equalsIgnoreCase("yami_yami");
                if (dual) {
                    this.minecraft.field_71466_p.func_175063_a(TextFormatting.BOLD + "" + yamiFruit.func_200301_q().func_150254_d() + " + " + df.func_200301_q().func_150254_d(), (float)(posX - 28), (float)(posY + 194), -1);
                } else {
                    this.minecraft.field_71466_p.func_175063_a(TextFormatting.BOLD + "" + yamiFruit.func_200301_q().func_150254_d(), (float)(posX - 28), (float)(posY + 194), -1);
                }
                if (dual) {
                    this.drawItemStack(df, posX - 56, posY + 187, "");
                }
                this.drawItemStack(yamiFruit, posX - 50, posY + 190, "");
            } else {
                ItemStack df = DevilFruitHelper.getDevilFruitItem(this.devilFruitProps.getDevilFruit());
                boolean doubleYamiCheck = false;
                String dfKey = DevilFruitHelper.getDevilFruitKey((AkumaNoMiItem)df.func_77973_b());
                if (dfKey.equalsIgnoreCase("yami_yami") && this.devilFruitProps.hasYamiPower()) {
                    doubleYamiCheck = true;
                }
                if (this.devilFruitProps.hasYamiPower() && !doubleYamiCheck) {
                    this.minecraft.field_71466_p.func_175063_a(TextFormatting.BOLD + "" + yamiFruit.func_200301_q().func_150254_d() + " + " + df.func_200301_q().func_150254_d(), (float)(posX - 28), (float)(posY + 194), -1);
                } else {
                    this.minecraft.field_71466_p.func_175063_a(TextFormatting.BOLD + "" + df.func_200301_q().func_150254_d(), (float)(posX - 28), (float)(posY + 194), -1);
                }
                if (this.devilFruitProps.hasYamiPower() && !doubleYamiCheck) {
                    this.drawItemStack(yamiFruit, posX - 56, posY + 187, "");
                }
                this.drawItemStack(df, posX - 50, posY + 190, "");
            }
        }
        super.render(x, y, f);
    }

    public void init() {
        WyNetwork.sendToServer(new CRequestSyncWorldDataPacket());
        this.entityStatsProps = EntityStatsCapability.get((LivingEntity)this.player);
        this.devilFruitProps = DevilFruitCapability.get((LivingEntity)this.player);
        this.challengesProps = ChallengesDataCapability.get(this.player);
        IQuestData questProps = QuestDataCapability.get(this.player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)this.player);
        int posX = (this.width - 256) / 2 - 110;
        int posY = (this.height - 256) / 2;
        boolean hasAbilities = abilityProps.countUnlockedAbilities(APIConfig.AbilityCategory.ALL) > 0;
        Button abilitiesButton = new Button(posX += 80, posY + 210, 70, 20, I18n.func_135052_a((String)ModI18n.GUI_ABILITIES, (Object[])new Object[0]), b -> Minecraft.func_71410_x().func_147108_a((Screen)new SelectHotbarAbilitiesScreen(this.player)));
        if (!hasAbilities) {
            abilitiesButton.active = false;
        }
        this.addButton((Widget)abilitiesButton);
        if (this.hasQuests) {
            boolean hasQuests = questProps.countInProgressQuests() > 0;
            Button questsButton = new Button(posX += 80, posY + 210, 70, 20, I18n.func_135052_a((String)ModI18n.GUI_QUESTS, (Object[])new Object[0]), b -> {
                WyNetwork.sendToServer(new CRequestSyncQuestDataPacket());
                Minecraft.func_71410_x().func_147108_a((Screen)new QuestsTrackerScreen(this.player));
            });
            if (!hasQuests) {
                questsButton.active = false;
            }
            this.addButton((Widget)questsButton);
        }
        if (this.entityStatsProps.isPirate()) {
            boolean hasCrew = this.worldProps.getCrewWithMember(this.player.func_110124_au()) != null;
            Button crewButton = new Button(posX += 80, posY + 210, 70, 20, I18n.func_135052_a((String)ModI18n.GUI_CREW, (Object[])new Object[0]), b -> Minecraft.func_71410_x().func_147108_a((Screen)new CrewDetailsScreen()));
            if (!hasCrew) {
                crewButton.active = false;
            }
            this.addButton((Widget)crewButton);
        }
        if (this.hasChallenges) {
            boolean hasChallenges = this.challengesProps.countChallenges() > 0;
            Button challengesButton = new Button(posX += 80, posY + 210, 70, 20, I18n.func_135052_a((String)ModI18n.GUI_CHALLENGES, (Object[])new Object[0]), b -> WyNetwork.sendToServer(new COpenChallengesScreenPacket()));
            if (this.player.field_70170_p.field_73011_w.func_186058_p() == DimensionType.func_193417_a((ResourceLocation)ModResources.DIMENSION_TYPE_CHALLENGES)) {
                challengesButton.active = false;
            }
            if (!hasChallenges) {
                challengesButton.active = false;
            }
            this.addButton((Widget)challengesButton);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void drawItemStack(ItemStack itemStack, int x, int y, String string) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.itemRenderer.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (itemStack != null) {
            font = itemStack.func_77973_b().getFontRenderer(itemStack);
        }
        if (font == null) {
            font = this.font;
        }
        this.itemRenderer.func_180450_b(itemStack, x, y);
        this.itemRenderer.field_77023_b = 0.0f;
    }

    public static void open(boolean hasQuests, boolean hasChallenges) {
        Minecraft.func_71410_x().func_147108_a((Screen)new PlayerStatsScreen(hasQuests, hasChallenges));
    }
}

