/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRoger;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WantedPosterScreen
extends Screen {
    private CompoundNBT wantedData;
    private ExtendedWorldData worldData;
    private JollyRoger jollyRoger;
    private GameProfile profile;
    private UUID wantedPlayerUUID;

    public WantedPosterScreen() {
        super((ITextComponent)new StringTextComponent(""));
        this.wantedData = Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77978_p();
        this.minecraft = Minecraft.func_71410_x();
        this.worldData = ExtendedWorldData.get(this.minecraft.field_71439_g.field_70170_p);
        this.wantedPlayerUUID = UUID.fromString(this.wantedData.func_74779_i("UUID"));
        this.profile = NBTUtil.func_152459_a((CompoundNBT)((CompoundNBT)this.wantedData.func_74781_a("Owner")));
        Crew crew = this.worldData.getCrewWithMember(this.wantedPlayerUUID);
        if (crew != null) {
            this.jollyRoger = crew.getJollyRoger();
        }
    }

    public void render(int x, int y, float f) {
        boolean flag;
        Map map;
        this.renderBackground();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = (this.width - 256) / 2;
        int posY = (this.height - 256) / 2;
        GL11.glTranslated((double)(posX + 60), (double)(posY + 10), (double)0.0);
        GL11.glTranslated((double)128.0, (double)128.0, (double)512.0);
        GL11.glScaled((double)1.0, (double)0.9, (double)0.0);
        GL11.glTranslated((double)-128.0, (double)-128.0, (double)-512.0);
        this.minecraft.func_110434_K().func_110577_a(ModResources.BOUNTY_POSTER_LARGE);
        GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)220, (int)250, (float)0.0f);
        GL11.glTranslated((double)67.0, (double)150.0, (double)0.0);
        GL11.glTranslated((double)128.0, (double)128.0, (double)512.0);
        GL11.glScaled((double)1.5, (double)1.6, (double)0.0);
        GL11.glTranslated((double)-128.0, (double)-128.0, (double)-512.0);
        String name = this.wantedData.func_74779_i("Name");
        String background = this.wantedData.func_74779_i("Background");
        String faction = this.wantedData.func_74779_i("Faction");
        DecimalFormat decimalFormat = new DecimalFormat("#,##0");
        String bounty = decimalFormat.format(this.wantedData.func_74763_f("Bounty"));
        GL11.glPushMatrix();
        ResourceLocation rs = new ResourceLocation("mineminenomi", "textures/gui/wantedposters/backgrounds/" + background + ".jpg");
        this.minecraft.func_110434_K().func_110577_a(rs);
        GL11.glScaled((double)0.34, (double)0.245, (double)0.0);
        GuiUtils.drawTexturedModalRect((int)23, (int)-57, (int)0, (int)0, (int)256, (int)256, (float)2.0f);
        GL11.glDisable((int)3042);
        rs = this.profile != null ? ((map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(this.profile)).containsKey(MinecraftProfileTexture.Type.SKIN) ? Minecraft.func_71410_x().func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.func_177334_a((UUID)this.wantedPlayerUUID)) : DefaultPlayerSkin.func_177334_a((UUID)this.wantedPlayerUUID);
        this.minecraft.func_110434_K().func_110577_a(rs);
        GL11.glScaled((double)4.25, (double)5.5, (double)0.0);
        GuiUtils.drawTexturedModalRect((int)20, (int)-3, (int)32, (int)32, (int)32, (int)32, (float)3.0f);
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        double scale = 0.08;
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        RenderSystem.translated((double)550.0, (double)190.0, (double)0.0);
        if (faction.equalsIgnoreCase("pirate")) {
            if (this.jollyRoger != null) {
                RendererHelper.drawPlayerJollyRoger(this.jollyRoger);
            }
        } else if (faction.equalsIgnoreCase("revolutionary")) {
            this.minecraft.func_110434_K().func_110577_a(ModResources.REVOLUTIONARY_ARMY_ICON);
            RenderSystem.scaled((double)2.0, (double)2.0, (double)2.0);
            RenderSystem.translated((double)-55.0, (double)-40.0, (double)0.0);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)256, (int)256, (int)256, (int)256, (float)0.0f);
        }
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        if (this.worldData.getBounty(this.wantedPlayerUUID.toString()) != Long.parseLong(bounty.replaceAll("\\D+", ""))) {
            RenderSystem.pushMatrix();
            this.minecraft.func_110434_K().func_110577_a(ModResources.EXPIRED);
            scale = 0.2;
            RenderSystem.scaled((double)(scale + 0.022), (double)scale, (double)scale);
            RenderSystem.translated((double)50.0, (double)-47.0, (double)0.0);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)16, (int)16, (int)256, (int)256, (float)0.0f);
            RenderSystem.popMatrix();
        }
        GL11.glPopMatrix();
        this.minecraft.func_110434_K().func_110577_a(ModResources.CURRENCIES);
        GuiUtils.drawTexturedModalRect((int)-2, (int)63, (int)0, (int)0, (int)32, (int)32, (float)1.0f);
        if (name.length() > 13) {
            name = name.substring(0, 10) + "...";
        }
        this.minecraft.field_71466_p.func_211126_b(TextFormatting.BOLD + name, (float)(47 - this.minecraft.field_71466_p.func_78256_a(name) / 2), 62.0f, WyHelper.hexToRGB("513413").getRGB());
        boolean bl = flag = bounty.length() > 10;
        if (flag) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)-21.0, (double)-5.0, (double)0.0);
            GL11.glTranslated((double)128.0, (double)128.0, (double)512.0);
            GL11.glScaled((double)0.82, (double)0.89, (double)0.0);
            GL11.glTranslated((double)-128.0, (double)-128.0, (double)-512.0);
        }
        this.minecraft.field_71466_p.func_211126_b(TextFormatting.BOLD + bounty, 22.0f, 76.0f, WyHelper.hexToRGB("513413").getRGB());
        if (flag) {
            GL11.glPopMatrix();
        }
        GL11.glTranslated((double)-24.0, (double)-2.0, (double)0.0);
        GL11.glTranslated((double)128.0, (double)128.0, (double)512.0);
        GL11.glScaled((double)0.78, (double)0.92, (double)0.0);
        GL11.glTranslated((double)-128.0, (double)-128.0, (double)-512.0);
        this.minecraft.field_71466_p.func_211126_b(TextFormatting.BOLD + this.wantedData.func_74779_i("Date"), (float)(36 - this.minecraft.field_71466_p.func_78256_a(this.wantedData.func_74779_i("Date")) / 2), 90.0f, WyHelper.hexToRGB("513413").getRGB());
        super.render(x, y, f);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static void open() {
        Minecraft.func_71410_x().func_147108_a((Screen)new WantedPosterScreen());
    }
}

