/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.pixelatedw.mineminenomi.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.screens.ChallengesScreen;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AvailableChallengesListPanel
extends ScrollPanel {
    private ChallengesScreen parent;
    private IChallengesData props;
    private List<Challenge> availableChallenges = new ArrayList<Challenge>();
    private static final int ENTRY_HEIGHT = 20;
    private FontRenderer font;
    public Optional<Challenge> currentChallenge;

    public AvailableChallengesListPanel(ChallengesScreen parent, IChallengesData props, List<Challenge> list) {
        super(parent.getMinecraft(), 200, 180, parent.height / 2 - 120, parent.width / 2 - 270);
        this.parent = parent;
        this.props = props;
        this.font = parent.getMinecraft().field_71466_p;
        this.availableChallenges.clear();
        this.availableChallenges = list;
        this.scrollDistance = -10.0f;
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return true;
    }

    protected int getContentHeight() {
        return (int)((double)this.availableChallenges.size() * 55.0 - 2.0);
    }

    protected int getScrollAmount() {
        return 12;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        Tessellator tess = Tessellator.func_178181_a();
        Objects.requireNonNull(this);
        int baseY = this.top + 4 - (int)this.scrollDistance;
        this.drawPanel(this.right, baseY, tess, mouseX, mouseY);
    }

    protected void drawPanel(int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        for (Challenge challenge : this.availableChallenges) {
            if (challenge == null) continue;
            float y = relativeY;
            float x = this.parent.width / 2 - 109 - 40;
            String formattedChallengeName = I18n.func_135052_a((String)challenge.getId(), (Object[])new Object[0]);
            String challengeColor = "#FFFFFF";
            if (challenge.isComplete()) {
                challengeColor = "#FFAA33";
            }
            if (challenge.isLocked((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
                formattedChallengeName = "???";
                challengeColor = "#616161";
            }
            RenderSystem.pushMatrix();
            if (this.isMouseOverChallenge(mouseX, mouseY, challenge)) {
                RenderSystem.color3f((float)0.8f, (float)0.8f, (float)0.8f);
                RenderSystem.translated((double)0.0, (double)-2.0, (double)0.0);
            }
            RenderSystem.pushMatrix();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.SCROLL);
            double scale = 0.5;
            RenderSystem.translated((double)(x - 180.0f), (double)(y - 196.0f), (double)0.0);
            RenderSystem.translated((double)256.0, (double)256.0, (double)0.0);
            RenderSystem.scaled((double)(scale * 1.1), (double)(scale * 0.6), (double)0.0);
            RenderSystem.translated((double)-256.0, (double)-256.0, (double)0.0);
            if (this.currentChallenge != null && this.currentChallenge.isPresent() && challenge.equals((Object)this.currentChallenge.get())) {
                RenderSystem.pushMatrix();
                RenderSystem.color3f((float)0.7f, (float)0.5f, (float)0.3f);
                RenderSystem.scaled((double)1.04, (double)1.07, (double)0.0);
                RenderSystem.translated((double)-4.0, (double)-7.0, (double)0.0);
                GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.popMatrix();
            }
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)1.0f);
            RenderSystem.popMatrix();
            if (this.font.func_78256_a(formattedChallengeName) > 140) {
                RenderSystem.pushMatrix();
                List<String> splittedText = WyHelper.splitString(this.font, formattedChallengeName, (int)x - 80, 140);
                RenderSystem.translated((double)0.0, (double)(-((splittedText.size() - 1) * 5)), (double)0.0);
                for (String string : splittedText) {
                    WyHelper.drawStringWithBorder(this.font, string, (int)x - 35, (int)y + 16, WyHelper.hexToRGB(challengeColor).getRGB());
                    y += 10.0f;
                }
                RenderSystem.popMatrix();
            } else {
                WyHelper.drawStringWithBorder(this.font, formattedChallengeName, (int)x - 35, (int)y + 16, WyHelper.hexToRGB(challengeColor).getRGB());
            }
            RenderSystem.popMatrix();
            relativeY = (int)((double)relativeY + 55.0);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Challenge challenge = this.findChallengeEntry((int)mouseX, (int)mouseY);
        if (button != 0 || challenge == null) {
            return false;
        }
        if (challenge.isLocked((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            return false;
        }
        this.parent.selectChallengeEntry(challenge);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private Challenge findChallengeEntry(int mouseX, int mouseY) {
        boolean isHovered;
        double offset = (float)(mouseY - this.top) + this.scrollDistance;
        boolean bl = isHovered = mouseX - 60 >= this.left && mouseY >= this.top && mouseX < this.left + this.width - 5 && mouseY < this.top + this.height;
        if (offset <= 0.0 || !isHovered) {
            return null;
        }
        int lineIdx = (int)(offset / 55.0);
        if (lineIdx >= this.availableChallenges.size()) {
            return null;
        }
        Challenge challenge = this.availableChallenges.get(lineIdx);
        if (challenge != null) {
            return challenge.create();
        }
        return null;
    }

    public boolean isMouseOverChallenge(double mouseX, double mouseY, Challenge overChallenge) {
        Challenge challenge = this.findChallengeEntry((int)mouseX, (int)mouseY);
        if (challenge != null && challenge.equals((Object)overChallenge)) {
            return super.isMouseOver(mouseX, mouseY);
        }
        return false;
    }
}

