/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.gui.ScrollPanel;
import xyz.pixelatedw.mineminenomi.api.TradeEntry;
import xyz.pixelatedw.mineminenomi.screens.TraderScreen;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ItemListScreenPanel
extends ScrollPanel {
    private TraderScreen parent;
    private List<TradeEntry> entries = new ArrayList<TradeEntry>();
    private static final int ENTRY_HEIGHT = 20;

    public ItemListScreenPanel(TraderScreen parent, List<TradeEntry> list) {
        super(parent.getMinecraft(), 215, 140, parent.height / 2 - 50, parent.width / 2 - 109);
        this.parent = parent;
        this.entries = list;
        for (TradeEntry entry : this.entries) {
            if (!entry.getItemStack().func_196082_o().func_74767_n("isClone") || entry.getItemStack().func_196082_o().func_74767_n("hasCloneTag")) continue;
            entry.getItemStack().func_200302_a((ITextComponent)new StringTextComponent(TextFormatting.RESET + entry.getItemStack().func_200301_q().func_150254_d() + " (Replica)"));
            entry.getItemStack().func_196082_o().func_74757_a("hasCloneTag", true);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int partialTicks) {
        return true;
    }

    protected int getContentHeight() {
        return (int)((double)this.entries.size() * 25.0 + 2.0);
    }

    protected int getScrollAmount() {
        return 10;
    }

    protected void drawPanel(int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        for (TradeEntry entry : this.entries) {
            int y = relativeY;
            int x = this.parent.width / 2 - 109 + 40;
            this.parent.renderItem(entry.getItemStack(), x - 30, y - 1);
            if (this.parent.getSelectedStack() != null && entry.getItemStack().hashCode() == this.parent.getSelectedStack().getItemStack().hashCode()) {
                WyHelper.drawColourOnScreen(Color.WHITE.getRGB(), 100, x - 40, y - 4, this.width, 24.0, 0.0);
            }
            this.parent.drawSizedString(entry.getItemStack().func_200301_q().func_150254_d(), x + 50, y + 4, 0.8f, -1);
            this.parent.drawSizedString(entry.getPrice() + "", x + 122, y + 4, 0.8f, -1);
            relativeY = (int)((double)relativeY + 25.0);
        }
    }

    public TradeEntry findStackEntry(int mouseX, int mouseY) {
        boolean isHovered;
        double offset = (float)(mouseY - this.top) + this.scrollDistance;
        boolean bl = isHovered = mouseX >= this.left && mouseY >= this.top && mouseX < this.left + this.width - 5 && mouseY < this.top + this.height;
        if (offset <= 0.0 || !isHovered) {
            return null;
        }
        int lineIdx = (int)(offset / 25.0);
        if (lineIdx >= this.entries.size()) {
            return null;
        }
        TradeEntry entry = this.entries.get(lineIdx);
        if (entry != null && mouseX >= this.left && mouseX <= this.right && mouseY <= this.bottom) {
            return entry;
        }
        return null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean isHovered;
        TradeEntry entry = this.findStackEntry((int)mouseX, (int)mouseY);
        boolean bl = isHovered = mouseX >= (double)this.left && mouseY >= (double)this.top && mouseX < (double)(this.left + this.width - 5) && mouseY < (double)(this.top + this.height);
        if (isHovered && entry != null) {
            this.parent.setSelectedStack(entry);
            this.parent.setWantedAmount(1);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void removeEntry(ItemStack stack) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.get(i).getItemStack().func_77973_b() != stack.func_77973_b()) continue;
            this.entries.remove(i);
        }
    }
}

