/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.TextTable;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NewButton
extends Button {
    private IEntityStats entityData;
    private boolean isSelected;
    private TextTable.Alignment textAlignment = TextTable.Alignment.LEFT;
    private int lineThickness = 1;
    private boolean hasIcons = true;
    private int blackColor = WyHelper.hexToRGB("#000000").getRGB();

    public NewButton(int posX, int posY, int width, int height, String string, Button.IPressable onPress) {
        super(posX, posY, width, height, string, onPress);
        this.entityData = EntityStatsCapability.get((LivingEntity)Minecraft.func_71410_x().field_71439_g);
    }

    public void setTextAlignment(TextTable.Alignment alignment) {
        this.textAlignment = alignment;
    }

    public void setLineThickness(int thickness) {
        this.lineThickness = thickness;
    }

    public void disableIcons() {
        this.hasIcons = false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.pushMatrix();
        if (this.visible) {
            ResourceLocation factionIcon;
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            int rgb = WyHelper.hexToRGB("#FFFFFF").getRGB();
            int lineColor = WyHelper.hexToRGB("#EAEAEA").getRGB();
            if (this.isHovered) {
                int factionColor;
                RenderSystem.translated((double)0.0, (double)0.5, (double)0.0);
                rgb = lineColor = (factionColor = FactionHelper.getFactionColor(this.entityData));
            }
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int textPosX = this.textAlignment == TextTable.Alignment.CENTER ? this.x - font.func_78256_a(this.getMessage()) / 2 + this.width / 2 : (this.textAlignment == TextTable.Alignment.RIGHT ? this.x : this.x);
            this.fillGradient(this.x - 4, this.y + this.height - this.lineThickness + 2, this.width + this.x + 1, this.y + this.height, this.blackColor, this.blackColor);
            this.fillGradient(this.x - 5, this.y + this.height - this.lineThickness, this.width + this.x, this.y + this.height, lineColor, lineColor);
            int textOffset = 0;
            if (this.hasIcons && (factionIcon = FactionHelper.getFactionIcon(this.entityData)) != null) {
                WyHelper.drawIcon(factionIcon, this.x - 12, this.y - 4, 32, 32, this.blackColor);
                WyHelper.drawIcon(factionIcon, this.x - 13, this.y - 5, 32, 32, lineColor);
                textOffset = 13;
            }
            WyHelper.drawStringWithBorder(font, this.getMessage(), textPosX + textOffset, this.y + this.height / 2 - 4, rgb);
        }
        RenderSystem.popMatrix();
    }
}

