/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;

public abstract class OPStructure<C extends IFeatureConfig>
extends Structure<C> {
    public OPStructure(Function<Dynamic<?>, ? extends C> configFactoryIn) {
        super(configFactoryIn);
    }

    public ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int chunkX, int chunkZ, int offsetX, int offsetsZ) {
        int featureDistance = this.getFeatureDistance(chunkGenerator);
        int featureSeparation = this.getFeatureSeparation(chunkGenerator);
        int posX = chunkX + featureDistance * offsetX;
        int posZ = chunkZ + featureDistance * offsetsZ;
        int validChunkX = (posX < 0 ? posX - featureDistance + 1 : posX) / featureDistance;
        int validChunkZ = (posZ < 0 ? posZ - featureDistance + 1 : posZ) / featureDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), validChunkX, validChunkZ, this.getSeedModifier());
        validChunkX *= featureDistance;
        validChunkZ *= featureDistance;
        return new ChunkPos(validChunkX += random.nextInt(featureDistance - featureSeparation), validChunkZ += random.nextInt(featureDistance - featureSeparation));
    }

    public boolean func_225558_a_(BiomeManager biomeManager, ChunkGenerator<?> chunkGen, Random rand, int chunkX, int chunkZ, Biome biome) {
        boolean sameChunk;
        ChunkPos chunkPos = this.func_211744_a(chunkGen, rand, chunkX, chunkZ, 0, 0);
        boolean bl = sameChunk = chunkX == chunkPos.field_77276_a && chunkZ == chunkPos.field_77275_b;
        if (!sameChunk) {
            return false;
        }
        int i = chunkX * 16;
        int j = chunkZ * 16;
        BlockPos blockpos = new BlockPos(i, 90, j);
        int dist = biome.func_201856_r() == Biome.Category.OCEAN ? 128 : 80;
        for (BlockPos pos : StructuresHelper.SPAWNED_STRUCTURES) {
            if (!blockpos.func_218141_a((Vec3i)pos, (double)dist)) continue;
            return false;
        }
        for (Biome biomeCheck : chunkGen.func_202090_b().func_225530_a_(chunkX * 16 + 9, 64, chunkZ * 16 + 9, this.func_202367_b() * 16)) {
            if (chunkGen.func_202094_a(biomeCheck, (Structure)this)) continue;
            return false;
        }
        return true;
    }

    public abstract Structure.IStartFactory func_214557_a();

    public abstract String func_143025_a();

    public abstract int func_202367_b();

    public abstract int getFeatureDistance(ChunkGenerator<?> var1);

    public abstract int getFeatureSeparation(ChunkGenerator<?> var1);

    public abstract int getSeedModifier();

    public static abstract class OPStructureStart
    extends StructureStart {
        private Block base;

        public OPStructureStart(Structure<?> structure, int chunkX, int chunkZ, MutableBoundingBox bb, int i3, long seed) {
            super(structure, chunkX, chunkZ, bb, i3, seed);
        }

        public void setBase(Block block) {
            this.base = block;
        }

        public void func_225565_a_(IWorld world, ChunkGenerator<?> generator, Random rand, MutableBoundingBox bb, ChunkPos chunkPos) {
            super.func_225565_a_(world, generator, rand, bb, chunkPos);
            if (this.base == null) {
                return;
            }
            int i = this.field_75074_b.field_78895_b;
            for (int j = bb.field_78897_a; j <= bb.field_78893_d; ++j) {
                for (int k = bb.field_78896_c; k <= bb.field_78892_f; ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (world.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vec3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vec3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && (world.func_175623_d(blockpos1 = new BlockPos(j, l, k)) || world.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --l) {
                        world.func_180501_a(blockpos1, this.base.func_176223_P(), 2);
                    }
                }
            }
        }
    }
}

