/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.smallbase.marine;

import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.init.ModFeatures;
import xyz.pixelatedw.mineminenomi.world.features.structures.OPStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.smallbase.marine.MarineSmallBasePieces;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;

public class MarineSmallBaseStructure
extends OPStructure<NoFeatureConfig> {
    public MarineSmallBaseStructure() {
        super(NoFeatureConfig::func_214639_a);
    }

    @Override
    public String func_143025_a() {
        return new ResourceLocation("mineminenomi", "marine_small_base").toString();
    }

    @Override
    public int getSeedModifier() {
        return 19773711;
    }

    @Override
    public int func_202367_b() {
        return 6;
    }

    @Override
    public int getFeatureDistance(ChunkGenerator<?> chunkGenerator) {
        return 12;
    }

    @Override
    public int getFeatureSeparation(ChunkGenerator<?> chunkGenerator) {
        return 8;
    }

    @Override
    public boolean func_225558_a_(BiomeManager biomeManager, ChunkGenerator<?> chunkGen, Random rand, int chunkX, int chunkZ, Biome biome) {
        boolean canSpawn = CommonConfig.INSTANCE.canSpawnSmallBases();
        boolean isChance = MathHelper.func_151237_a((double)(WyHelper.randomWithRange(0, 100) + WyHelper.randomDouble()), (double)0.0, (double)100.0) < CommonConfig.INSTANCE.getChanceForSmallBasesSpawn();
        return canSpawn && isChance && super.func_225558_a_(biomeManager, chunkGen, rand, chunkX, chunkZ, biome);
    }

    @Override
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public static void register(Biome biome) {
        if (!CommonConfig.INSTANCE.canSpawnSmallBases()) {
            return;
        }
        if (biome.func_201856_r() == Biome.Category.PLAINS || biome.func_201856_r() == Biome.Category.BEACH || biome.func_201856_r() == Biome.Category.FOREST || biome.func_201856_r() == Biome.Category.MESA || biome.func_201856_r() == Biome.Category.SAVANNA) {
            Structure<NoFeatureConfig> feat = ModFeatures.MARINE_SMALL_BASE;
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, feat.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)new NoPlacementConfig())));
            biome.func_226711_a_(feat.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static class Start
    extends OPStructure.OPStructureStart {
        private TemplateManager templateManager;

        public Start(Structure<?> structure, int chunkX, int chunkZ, MutableBoundingBox bb, int i3, long seed) {
            super(structure, chunkX, chunkZ, bb, i3, seed);
            this.setBase(Blocks.field_150346_d);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome) {
            this.templateManager = templateManager;
            int i = this.func_214627_k().func_202367_b();
            int k = (chunkX << 4) + 7;
            int l = (chunkZ << 4) + 7;
            int i1 = generator.func_222531_c(k, l, Heightmap.Type.WORLD_SURFACE_WG);
            int j1 = generator.func_222531_c(k, l + i, Heightmap.Type.WORLD_SURFACE_WG);
            int k1 = generator.func_222531_c(k + i, l, Heightmap.Type.WORLD_SURFACE_WG);
            int l1 = generator.func_222531_c(k + i, l + i, Heightmap.Type.WORLD_SURFACE_WG);
            int i2 = Math.min(Math.min(i1, j1), Math.min(k1, l1));
            if (i2 >= 60) {
                BlockPos blockpos = new BlockPos(chunkX * 16 + 8, i2, chunkZ * 16 + 8);
                MarineSmallBasePieces.addComponents(this.templateManager, blockpos, this.field_75075_a);
                this.func_202500_a();
                StructuresHelper.SPAWNED_STRUCTURES.add(blockpos);
                StructuresHelper.STRUCTURES_COUNT[5] = StructuresHelper.STRUCTURES_COUNT[5] + 1;
                WyDebug.debug("Marine Small Base spawned at: /tp " + blockpos.func_177958_n() + " ~ " + blockpos.func_177952_p());
            }
        }
    }
}

