/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.spawners;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;

public class AmbushSpawner {
    private Random random = new Random();
    private int cooldown;

    public void tick(ServerWorld world) {
        world.func_217381_Z().func_76320_a("ambushSpawnerTick");
        if (--this.cooldown <= 0) {
            this.cooldown = CommonConfig.INSTANCE.getTimeBetweenAmbushSpawns();
            if (this.random.nextInt(100) <= CommonConfig.INSTANCE.getChanceForAmbushSpawn()) {
                this.spawn(world);
            }
        }
        world.func_217381_Z().func_76319_b();
    }

    private void spawn(ServerWorld world) {
        world.func_217381_Z().func_76320_a("ambushSpawnerSpawn");
        ServerPlayerEntity player = world.func_217472_l_();
        if (player == null) {
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.isPirate() || props.isBandit() || props.isRevolutionary()) {
            int i;
            List dangers;
            BlockPos targetPos = player.func_180425_c();
            long bounty = props.getBounty();
            boolean canSpawnInBiome = world.func_226691_t_(targetPos).func_201856_r() != Biome.Category.OCEAN;
            boolean canSeeSky = player.field_70170_p.func_175710_j(targetPos);
            if (!canSpawnInBiome || bounty < 10000L || !canSeeSky) {
                return;
            }
            EntityType captainEntity = ModEntities.MARINE_CAPTAIN;
            EntityType grunt1Entity = ModEntities.MARINE_WITH_SWORD;
            EntityType grunt2Entity = ModEntities.MARINE_WITH_GUN;
            int r = this.random.nextInt(2);
            if (r == 1) {
                // empty if block
            }
            if ((dangers = WyHelper.getEntitiesNear(targetPos, (World)world, 80.0, OPEntity.class)).size() > 50) {
                return;
            }
            int nrCaptains = 1 + (int)Math.ceil(bounty / 200000L);
            int nrGrunts = 3 + (int)Math.ceil(bounty / 100000L);
            if (nrCaptains > 3) {
                nrCaptains = 3;
            }
            if (nrGrunts > 30) {
                nrGrunts = 30;
            }
            for (i = 0; i < nrCaptains; ++i) {
                BlockPos spawnPos = WyHelper.findOnGroundSpawnLocation((World)world, captainEntity, targetPos, 10);
                if (spawnPos == null) continue;
                captainEntity.func_220342_a((World)world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
            }
            for (i = 0; i < nrGrunts; ++i) {
                EntityType gruntEntity = i % 2 == 0 ? grunt1Entity : grunt2Entity;
                BlockPos spawnPos = WyHelper.findOnGroundSpawnLocation((World)world, gruntEntity, targetPos, 20);
                if (spawnPos == null) continue;
                gruntEntity.func_220342_a((World)world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
            }
            WyDebug.debug("Ambush spawned around these coords: " + targetPos);
        }
        world.func_217381_Z().func_76319_b();
    }
}

