/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.mixins.ITemplateMixin;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class WyHelper {
    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty() || str.equalsIgnoreCase("n/a");
    }

    public static String formatBytes(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + "";
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String upperCaseFirst(String text) {
        return Character.toUpperCase(text.charAt(0)) + text.substring(1) + " ";
    }

    public static String getResourceName(String text) {
        return text.replaceAll("[ \\t]+$", "").replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\s+", "_").replaceAll("[\\'\\:\\-\\,\\#]", "").replaceAll("\\&", "and").toLowerCase();
    }

    public static String escapeJSON(String raw) {
        String escaped = raw;
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\b", "\\b");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\t", "\\t");
        return escaped;
    }

    public static Color hslToColor(float h, float s, float l) {
        if (s < 0.0f || s > 100.0f) {
            String message = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(message);
        }
        if (l < 0.0f || l > 100.0f) {
            String message = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(message);
        }
        h %= 360.0f;
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s) : (l /= 100.0f) + (s /= 100.0f) - s * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, WyHelper.hueToRGB(p, q, (h /= 360.0f) + 0.33333334f));
        float g = Math.max(0.0f, WyHelper.hueToRGB(p, q, h));
        float b = Math.max(0.0f, WyHelper.hueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        return new Color(r, g, b);
    }

    private static float hueToRGB(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }

    public static String rgbToHex(int red, int green, int blue) {
        return String.format("#%02X%02X%02X", red, green, blue);
    }

    public static Color hexToRGB(String hexColor) {
        if (hexColor.startsWith("#")) {
            hexColor = hexColor.substring(1);
        }
        if (hexColor.length() == 8) {
            int r = Integer.parseInt(hexColor.substring(0, 2), 16);
            int g = Integer.parseInt(hexColor.substring(2, 4), 16);
            int b = Integer.parseInt(hexColor.substring(4, 6), 16);
            int a = Integer.parseInt(hexColor.substring(6, 8), 16);
            return new Color(r, g, b, a);
        }
        return Color.decode("#" + hexColor);
    }

    public static Color getComplementaryColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static float colorTolerance(float tolerance) {
        return WyHelper.colorTolerance(tolerance, false);
    }

    public static float colorTolerance(float tolerance, boolean hasDisturbance) {
        float color = new Random().nextFloat();
        if (color <= tolerance || !hasDisturbance && (double)color >= (double)tolerance + 0.3) {
            return tolerance;
        }
        return color;
    }

    public static void spawnParticles(IParticleData data, ServerWorld world, double posX, double posY, double posZ) {
        SSpawnParticlePacket ipacket = new SSpawnParticlePacket(data, true, (double)((float)posX), (double)((float)posY), (double)((float)posZ), 0.0f, 0.0f, 0.0f, 0.0f, 1);
        for (int j = 0; j < world.func_217369_A().size(); ++j) {
            ServerPlayerEntity player = (ServerPlayerEntity)world.func_217369_A().get(j);
            BlockPos blockpos = new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            if (!blockpos.func_218137_a((IPosition)new Vec3d(posX, posY, posZ), 512.0)) continue;
            player.field_71135_a.func_147359_a((IPacket)ipacket);
        }
    }

    public static Vec3d propulsion(LivingEntity entity, double extraVelX, double extraVelZ) {
        return WyHelper.propulsion(entity, extraVelX, 0.0, extraVelZ);
    }

    public static Vec3d propulsion(LivingEntity entity, double extraVelX, double extraVelY, double extraVelZ) {
        return entity.func_70676_i(1.0f).func_216372_d(extraVelX, extraVelY, extraVelZ);
    }

    public static <T extends Entity> List<T> getEntitiesNear(BlockPos pos, World world, double radius) {
        return WyHelper.getEntitiesNear(pos, world, radius, LivingEntity.class);
    }

    public static <T extends Entity> List<T> getEntitiesNear(BlockPos pos, World world, double radius, Class<? extends T> ... classEntities) {
        return WyHelper.getEntitiesNear(pos, world, radius, null, classEntities);
    }

    public static <T extends Entity> List<T> getEntitiesNear(BlockPos pos, World world, double radius, Predicate<Entity> predicate, Class<? extends T> ... classEntities) {
        predicate = predicate != null ? predicate.and(EntityPredicates.field_180132_d) : EntityPredicates.field_180132_d;
        AxisAlignedBB aabb = new AxisAlignedBB(pos).func_72314_b(radius, radius, radius);
        ArrayList list = new ArrayList();
        for (Class<? extends T> clzz : classEntities) {
            list.addAll(world.func_175647_a(clzz, aabb, predicate));
        }
        return list;
    }

    public static <T extends PlayerEntity> List<T> getNearestPlayers(IWorld world, double x, double y, double z, double distance) {
        ArrayList<PlayerEntity> list = new ArrayList<PlayerEntity>();
        for (PlayerEntity target : world.func_217369_A()) {
            if (!EntityPredicates.field_180132_d.test(target) || !EntityPredicates.field_212545_b.test(target)) continue;
            double d0 = target.func_70092_e(x, y, z);
            if (!(distance < 0.0) && !(d0 < distance * distance)) continue;
            list.add(target);
        }
        return list;
    }

    public static <T extends Entity> List<T> getEntitiesNearSphere(BlockPos pos, World world, double radius, @Nullable Predicate<Entity> predicate, Class<? extends T> ... classEntities) {
        predicate = predicate != null ? predicate.and(EntityPredicates.field_180132_d) : EntityPredicates.field_180132_d;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        AxisAlignedBB aabb = new AxisAlignedBB((double)x - (radius *= 2.0), (double)y - radius, (double)z - radius, (double)x + radius, (double)y + radius, (double)z + radius);
        ArrayList list = new ArrayList();
        for (Class<? extends T> clzz : classEntities) {
            list.addAll(world.func_175647_a(clzz, aabb, predicate));
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!(((Entity)list.get(i)).func_70092_e((double)x, (double)y, (double)z) >= radius)) continue;
            list.remove(i);
            break;
        }
        return list;
    }

    public static RayTraceResult rayTraceBlocksAndEntities(Entity entity) {
        return WyHelper.rayTraceBlocksAndEntities(entity, 1024.0, 0.4f);
    }

    public static RayTraceResult rayTraceBlocksAndEntities(Entity entity, double distance) {
        return WyHelper.rayTraceBlocksAndEntities(entity, distance, 0.2f);
    }

    public static RayTraceResult rayTraceBlocksAndEntities(Entity entity, double distance, float entityBoxRange) {
        Vec3d lookVec = entity.func_70040_Z();
        Vec3d startVec = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        Vec3d endVec = startVec.func_178787_e(entity.func_70040_Z().func_186678_a(distance));
        BlockRayTraceResult blockResult = entity.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity));
        EntityRayTraceResult entityResult = null;
        int i = 0;
        while ((double)i < distance * 2.0 && entityResult == null) {
            float scale = (float)i / 2.0f;
            Vec3d pos = startVec.func_178787_e(lookVec.func_186678_a((double)scale));
            Vec3d min = pos.func_72441_c((double)entityBoxRange, (double)entityBoxRange, (double)entityBoxRange);
            Vec3d max = pos.func_72441_c((double)(-entityBoxRange), (double)(-entityBoxRange), (double)(-entityBoxRange));
            for (Entity e : entity.field_70170_p.func_72839_b(entity, new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c))) {
                if (e instanceof LightningEntity) continue;
                entityResult = new EntityRayTraceResult(e, pos);
                break;
            }
            ++i;
        }
        if (entityResult != null && entityResult.func_216347_e().func_72438_d(startVec) <= blockResult.func_216347_e().func_72438_d(startVec)) {
            return entityResult;
        }
        return blockResult;
    }

    public static BlockPos rayTraceBlockSafe(PlayerEntity player, float range) {
        Vec3d endVec;
        World world = player.field_70170_p;
        Vec3d startVec = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        BlockRayTraceResult result = world.func_217299_a(new RayTraceContext(startVec, endVec = startVec.func_178787_e(player.func_70040_Z().func_186678_a((double)range)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)player));
        BlockPos dashPos = result.func_216354_b().equals((Object)Direction.DOWN) ? result.func_216350_a().func_177979_c(2) : result.func_216350_a().func_177972_a(result.func_216354_b());
        boolean posIsFree = WyHelper.isPosClearForPlayer(world, dashPos);
        boolean tryUp = true;
        while (!posIsFree) {
            if (tryUp) {
                boolean bl = posIsFree = WyHelper.isPosClearForPlayer(world, dashPos = dashPos.func_177984_a()) && world.func_217299_a(new RayTraceContext(startVec, new Vec3d((Vec3i)dashPos.func_177977_b()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)player)).func_216346_c().equals((Object)RayTraceResult.Type.MISS);
                if (world.getMaxHeight() < dashPos.func_177956_o()) continue;
                tryUp = false;
                continue;
            }
            boolean bl = posIsFree = WyHelper.isPosClearForPlayer(world, dashPos = dashPos.func_177977_b()) && world.func_217299_a(new RayTraceContext(startVec, new Vec3d((Vec3i)dashPos.func_177984_a()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)player)).func_216346_c().equals((Object)RayTraceResult.Type.MISS);
            if (dashPos.func_177956_o() > 0) continue;
        }
        return posIsFree ? dashPos : null;
    }

    public static boolean isPosClearForPlayer(World world, BlockPos pos) {
        return !(!world.func_175623_d(pos) && !world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b() || !world.func_175623_d(pos.func_177984_a()) && !world.func_180495_p(pos.func_177984_a()).func_196952_d((IBlockReader)world, pos.func_177984_a()).func_197766_b());
    }

    public static BlockPos getClearPositionForPlayer(World world, BlockPos pos) {
        boolean posIsFree = WyHelper.isPosClearForPlayer(world, pos);
        boolean tryUp = true;
        int initialY = pos.func_177956_o();
        while (!posIsFree) {
            if (tryUp) {
                pos = pos.func_177984_a();
                posIsFree = WyHelper.isPosClearForPlayer(world, pos);
                if (initialY + 5 < pos.func_177956_o()) continue;
                tryUp = false;
                continue;
            }
            pos = pos.func_177977_b();
            posIsFree = WyHelper.isPosClearForPlayer(world, pos);
            if (pos.func_177956_o() > initialY - 5) continue;
        }
        return posIsFree ? pos : null;
    }

    public static BlockRayTraceResult rayTraceBlocks(Entity source, double distance) {
        Vec3d startVec = source.func_213303_ch().func_72441_c(0.0, (double)source.func_70047_e(), 0.0);
        Vec3d endVec = startVec.func_178787_e(source.func_70040_Z().func_186678_a(distance));
        return source.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, source));
    }

    public static EntityRayTraceResult rayTraceEntities(Entity source, double distance) {
        Vec3d startVec = source.func_213303_ch().func_72441_c(0.0, (double)source.func_70047_e(), 0.0);
        Vec3d endVec = startVec.func_178787_e(source.func_70040_Z().func_186678_a(distance));
        AxisAlignedBB boundingBox = source.func_174813_aQ().func_186662_g(distance);
        for (Entity entity2 : source.field_70170_p.func_175674_a(source, boundingBox, entity -> entity != source)) {
            Vec3d targetVec;
            double distFromSource;
            AxisAlignedBB entityBB = entity2.func_174813_aQ().func_186662_g(1.0);
            Optional optional = entityBB.func_216365_b(startVec, endVec);
            if (!optional.isPresent() || !((distFromSource = (double)MathHelper.func_76133_a((double)startVec.func_72436_e(targetVec = (Vec3d)optional.get()))) < distance)) continue;
            List targets = WyHelper.getEntitiesNear(new BlockPos(targetVec), source.field_70170_p, 1.25);
            targets.remove(source);
            Optional target = targets.stream().findFirst();
            if (!target.isPresent()) continue;
            return new EntityRayTraceResult((Entity)target.get(), endVec);
        }
        return new EntityRayTraceResult(null, endVec);
    }

    public static boolean isBlockNearby(LivingEntity player, int radius, Block ... blocks) {
        for (Block b : blocks) {
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (player.field_70170_p.func_180495_p(new BlockPos(player.func_226277_ct_() + (double)x, player.func_226278_cu_() + (double)y, player.func_226281_cx_() + (double)z)).func_177230_c() != b) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static List<BlockPos> getNearbyBlocks(LivingEntity player, int radius) {
        return WyHelper.getNearbyBlocks(player.func_180425_c(), (IWorld)player.field_70170_p, radius);
    }

    public static List<BlockPos> getNearbyBlocks(BlockPos pos, IWorld world, int radius) {
        return WyHelper.getNearbyBlocks(pos, world, radius, (List<Block>)ImmutableList.of((Object)Blocks.field_150350_a));
    }

    public static List<BlockPos> getNearbyBlocks(BlockPos pos, IWorld world, int radius, List<Block> bannedBlocks) {
        ArrayList<BlockPos> blockLocations = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos newPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    Block block = world.func_180495_p(newPos).func_177230_c();
                    if (bannedBlocks.contains(block)) continue;
                    blockLocations.add(newPos);
                }
            }
        }
        return blockLocations;
    }

    public static List<BlockPos> getNearbyTileEntities(LivingEntity player, int radius) {
        return WyHelper.getNearbyTileEntities(player.func_180425_c(), player.field_70170_p, radius);
    }

    public static List<BlockPos> getNearbyTileEntities(BlockPos pos, World world, int radius) {
        ArrayList<BlockPos> blockLocations = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos newPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (world.func_180495_p(newPos).func_177230_c() == Blocks.field_150350_a || world.func_175625_s(newPos) == null) continue;
                    blockLocations.add(newPos);
                }
            }
        }
        return blockLocations;
    }

    public static BlockPos findOnGroundSpawnLocation(World world, EntityType type, BlockPos spawnLocation, int radius) {
        return WyHelper.findOnGroundSpawnLocation(world, type, spawnLocation, radius, 0);
    }

    @Nullable
    public static BlockPos findOnGroundSpawnLocation(World world, EntityType type, BlockPos spawnLocation, int radius, int offset) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = (int)WyHelper.randomWithRange(spawnLocation.func_177958_n() - offset - radius, spawnLocation.func_177958_n() + offset + radius);
            BlockPos blockpos1 = new BlockPos(x, y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = (int)WyHelper.randomWithRange(spawnLocation.func_177952_p() - offset - radius, spawnLocation.func_177952_p() + offset + radius)), z);
            if (!WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)world, (BlockPos)blockpos1, (EntityType)type)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    public static String getTextureName(String texture) {
        for (String s : texture.split("/")) {
            if (!s.contains(".png")) continue;
            return s.replace(".png", "");
        }
        return null;
    }

    public static boolean hasInventoryFull(PlayerEntity player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean setBlockStateInChunk(World world, BlockPos pos, BlockState newState, int flags) {
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        if (!world.field_72995_K && world.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        BlockState blockstate = chunk.func_177436_a(pos = pos.func_185334_h(), newState, (flags & 0x40) != 0);
        if (blockstate != null && (flags & 2) != 0 && (!world.field_72995_K || (flags & 4) == 0) && (world.field_72995_K || chunk == null || chunk.func_217321_u() != null && chunk.func_217321_u().func_219065_a(ChunkHolder.LocationType.TICKING))) {
            world.func_184138_a(pos, blockstate, newState, flags);
        }
        return true;
    }

    public static BlockState swapBlockData(IWorld world, BlockPos pos, BlockState newState) {
        IChunk chunk = world.func_217349_x(pos);
        ChunkSection cs = chunk.func_76587_i()[pos.func_177956_o() >> 4];
        if (cs == Chunk.field_186036_a) {
            chunk.func_76587_i()[pos.func_177956_o() >> 4] = cs = new ChunkSection(pos.func_177956_o() >> 4 << 4);
        }
        BlockState state = (BlockState)cs.func_186049_g().func_222639_b(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, (Object)newState);
        return state;
    }

    public static boolean afterDate(String date) {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        Calendar target = null;
        try {
            target = Calendar.getInstance();
            target.setTime(df.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        Calendar now = Calendar.getInstance();
        return now.after(target);
    }

    public static long getDaysSince(Date date) {
        Date now = new Date();
        long diffInMillies = Math.abs(now.getTime() - date.getTime());
        long diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS);
        return diff;
    }

    public static double percentage(double percent, double value) {
        return percent / 100.0 * value;
    }

    public static double randomWithRange(int min, int max) {
        return new Random().nextInt(max + 1 - min) + min;
    }

    public static double randomWithRange(Random rand, int min, int max) {
        return rand.nextInt(max + 1 - min) + min;
    }

    public static double randomDouble(Random rand) {
        return rand.nextDouble() * 2.0 - 1.0;
    }

    public static double randomDouble() {
        return new Random().nextDouble() * 2.0 - 1.0;
    }

    public static int round(int value) {
        String valueString = "" + value;
        if (valueString.length() < 1) {
            return value;
        }
        return WyHelper.round(value, valueString.length() - 1);
    }

    public static int round(int value, int nth) {
        String valueString = "" + value;
        if (valueString.length() < 1 || nth < 0) {
            return value;
        }
        if (nth == 0) {
            nth = 1;
        }
        int n = (int)Math.pow(10.0, nth - 1);
        int r = 5 * (n / 10);
        return (value + r) / n * n;
    }

    public static long clamp(long num, long min, long max) {
        return num < min ? min : Math.min(num, max);
    }

    public static void drawColourOnScreen(int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        WyHelper.drawColourOnScreen(r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColourOnScreen(int red, int green, int blue, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_(posX, posY + height, zLevel).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_225582_a_(posX + width, posY + height, zLevel).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_225582_a_(posX + width, posY, zLevel).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_225582_a_(posX, posY, zLevel).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawIcon(ResourceLocation rs, int x, int y, int u, int v) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rs);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x, (double)(y + v), 1.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + u), (double)(y + v), 1.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + u), (double)y, 1.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, 1.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawIcon(ResourceLocation rs, int x, int y, int u, int v, String hexColor) {
        Color color = WyHelper.hexToRGB(hexColor);
        WyHelper.drawIcon(rs, x, y, u, v, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static void drawIcon(ResourceLocation rs, int x, int y, int u, int v, int intColor) {
        String hex = String.format("#%06X", 0xFFFFFF & intColor);
        Color color = WyHelper.hexToRGB(hex);
        WyHelper.drawIcon(rs, x, y, u, v, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static void drawIcon(ResourceLocation rs, int x, int y, int u, int v, int red, int green, int blue, int alpha) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rs);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_225582_a_((double)x, (double)(y + v), 1.0).func_225586_a_(red, green, blue, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + u), (double)(y + v), 1.0).func_225586_a_(red, green, blue, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + u), (double)y, 1.0).func_225586_a_(red, green, blue, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, 1.0).func_225586_a_(red, green, blue, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @Deprecated
    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, LivingEntity entity) {
        InventoryScreen.func_228187_a_((int)posX, (int)posY, (int)scale, (float)mouseX, (float)mouseY, (LivingEntity)entity);
    }

    public static void drawStringWithBorder(FontRenderer font, String text, int posX, int posY, int color) {
        String unformattedText = WyHelper.escapeTextFormattingChars(text);
        font.func_175063_a(unformattedText, (float)posX, (float)posY - 0.7f, 1);
        font.func_175063_a(unformattedText, (float)posX, (float)posY + 0.7f, 1);
        font.func_175063_a(unformattedText, (float)posX + 0.7f, (float)posY, 1);
        font.func_175063_a(unformattedText, (float)posX - 0.7f, (float)posY, 1);
        font.func_211126_b(text, (float)posX, (float)posY, color);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
    }

    public static String escapeTextFormattingChars(String text) {
        return text.replaceAll("\u00a7[0-9a-f]", "");
    }

    public static List<String> splitString(FontRenderer font, String text, int posX, int wrapWidth) {
        while (text != null && text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        ArrayList<String> newText = new ArrayList<String>();
        for (String s : font.func_78271_c(text, wrapWidth)) {
            if (font.func_78260_a()) {
                int i = font.func_78256_a(font.func_147647_b(s));
                posX += wrapWidth - i;
            }
            newText.add(s);
        }
        return newText;
    }

    public static float handleRotationFloat(LivingEntity entity, float partialTicks) {
        return (float)entity.field_70173_aa + partialTicks;
    }

    public static void rotateCorpse(MatrixStack matrixStack, LivingEntity entityLiving, float ageInTicks, float headYawOffset, float partialTicks) {
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f + headYawOffset));
        if (entityLiving.field_70725_aQ > 0) {
            float animTime = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((animTime = MathHelper.func_76129_c((float)animTime)) > 1.0f) {
                animTime = 1.0f;
            }
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(animTime * 90.0f));
        }
    }

    @Deprecated
    public static float interpolateRotation(float lowerLimit, float upperLimit, float range) {
        float f3;
        for (f3 = upperLimit - lowerLimit; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return lowerLimit + range * f3;
    }

    public static void generateJSONLangs() {
        Map<String, String> sorted = WyHelper.sortAlphabetically(WyRegistry.getLangMap());
        Set<Map.Entry<String, String>> set = sorted.entrySet();
        Iterator<Map.Entry<String, String>> iter = set.iterator();
        Map.Entry<String, String> prevEntry = null;
        File langFolder = new File(APIConfig.getResourceFolderPath() + "/assets/" + APIConfig.projectId + "/lang/");
        langFolder.mkdirs();
        if (langFolder.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(APIConfig.getResourceFolderPath() + "/assets/" + APIConfig.projectId + "/lang/en_us.json"), "UTF-8"));){
                writer.write("{\n");
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    if (prevEntry != null && !((String)prevEntry.getKey()).substring(0, 2).equals(entry.getKey().substring(0, 2))) {
                        writer.write("\n");
                    }
                    String value = WyHelper.escapeJSON(entry.getValue());
                    if (iter.hasNext()) {
                        writer.write("\t\"" + entry.getKey() + "\": \"" + value + "\",\n");
                    } else {
                        writer.write("\t\"" + entry.getKey() + "\": \"" + value + "\"\n");
                    }
                    prevEntry = entry;
                }
                writer.write("}\n");
                ((Writer)writer).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> List<T> shuffle(List<T> ar) {
        Random rnd = new Random();
        for (int i = ar.size() - 1; i > 0; --i) {
            int index = rnd.nextInt(i + 1);
            T a = ar.get(index);
            ar.set(index, ar.get(i));
            ar.set(i, a);
        }
        return ar;
    }

    public static <K extends Comparable, V extends Comparable> Map<K, V> sortAlphabetically(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> entries = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getKey()).compareTo(o2.getKey());
            }
        });
        LinkedHashMap<Comparable, Comparable> sortedMap = new LinkedHashMap<Comparable, Comparable>();
        for (Map.Entry entry : entries) {
            sortedMap.put((Comparable)entry.getKey(), (Comparable)entry.getValue());
        }
        return sortedMap;
    }

    public static BlockPos[][] splitArray(BlockPos[] arrayToSplit, int chunkSize) {
        if (chunkSize <= 0) {
            return null;
        }
        int rest = arrayToSplit.length % chunkSize;
        int chunks = arrayToSplit.length / chunkSize + (rest > 0 ? 1 : 0);
        BlockPos[][] arrays = new BlockPos[chunks][];
        for (int i = 0; i < (rest > 0 ? chunks - 1 : chunks); ++i) {
            arrays[i] = Arrays.copyOfRange(arrayToSplit, i * chunkSize, i * chunkSize + chunkSize);
        }
        if (rest > 0) {
            arrays[chunks - 1] = Arrays.copyOfRange(arrayToSplit, (chunks - 1) * chunkSize, (chunks - 1) * chunkSize + rest);
        }
        return arrays;
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(out);
        os.writeObject(obj);
        return out.toByteArray();
    }

    public static Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ObjectInputStream is = new ObjectInputStream(in);
            is.close();
            return is.readObject();
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    public static final int getIndexOfItemStack(Item item, IInventory inven) {
        for (int i = 0; i < inven.func_70302_i_(); ++i) {
            if (inven.func_70301_a(i).func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static boolean saveNBTStructure(ServerWorld world, String name, BlockPos pos, BlockPos size, List<Block> toIgnore) {
        if (!world.field_72995_K) {
            Template template;
            ServerWorld serverworld = world;
            TemplateManager templatemanager = serverworld.func_184163_y();
            ResourceLocation res = new ResourceLocation(APIConfig.projectId, name);
            try {
                template = templatemanager.func_200220_a(res);
            }
            catch (ResourceLocationException ex) {
                ex.printStackTrace();
                return false;
            }
            toIgnore.add(Blocks.field_189881_dj);
            toIgnore.add(Blocks.field_150357_h);
            WyHelper.takeBlocksFromWorld(template, (World)world, pos, size, toIgnore);
            template.func_186252_a("?");
            try {
                return templatemanager.func_195429_b(res);
            }
            catch (ResourceLocationException var7) {
                return false;
            }
        }
        return false;
    }

    public static boolean loadNBTStructure(ServerWorld world, String name, BlockPos pos) {
        PlacementSettings placement = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(true).func_186218_a((ChunkPos)null);
        placement.func_215219_b().func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c).func_215222_a((StructureProcessor)new IntegrityProcessor(1.0f)).func_189950_a(new Random(Util.func_211177_b()));
        return WyHelper.loadNBTStructure(world, name, pos, placement);
    }

    public static boolean loadNBTStructure(ServerWorld world, String name, BlockPos pos, PlacementSettings settings) {
        if (!world.field_72995_K) {
            Template template;
            TemplateManager templatemanager = world.func_184163_y();
            ResourceLocation res = new ResourceLocation("mineminenomi", name);
            try {
                template = templatemanager.func_200219_b(res);
            }
            catch (ResourceLocationException ex) {
                ex.printStackTrace();
                return false;
            }
            if (template == null) {
                return false;
            }
            BlockState blockstate = world.func_180495_p(pos);
            world.func_184138_a(pos, blockstate, blockstate, 3);
            template.func_186260_a((IWorld)world, pos, settings);
            return true;
        }
        return false;
    }

    public static void takeBlocksFromWorld(Template template, World world, BlockPos startPos, BlockPos size, @Nullable List<Block> toIgnore) {
        if (size.func_177958_n() >= 1 && size.func_177956_o() >= 1 && size.func_177952_p() >= 1) {
            BlockPos blockpos = startPos.func_177971_a((Vec3i)size).func_177982_a(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.func_177958_n(), blockpos.func_177958_n()), Math.min(startPos.func_177956_o(), blockpos.func_177956_o()), Math.min(startPos.func_177952_p(), blockpos.func_177952_p()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.func_177958_n(), blockpos.func_177958_n()), Math.max(startPos.func_177956_o(), blockpos.func_177956_o()), Math.max(startPos.func_177952_p(), blockpos.func_177952_p()));
            ((ITemplateMixin)template).setSize(size);
            for (BlockPos blockpos3 : BlockPos.func_218278_a((BlockPos)blockpos1, (BlockPos)blockpos2)) {
                TileEntity tileentity;
                BlockPos blockpos4 = blockpos3.func_177973_b((Vec3i)blockpos1);
                BlockState blockstate = world.func_180495_p(blockpos3);
                if (toIgnore != null && toIgnore.contains(blockstate.func_177230_c())) {
                    world.func_175656_a(blockpos3, Blocks.field_150350_a.func_176223_P());
                    blockstate = world.func_180495_p(blockpos3);
                }
                if ((tileentity = world.func_175625_s(blockpos3)) != null) {
                    CompoundNBT compoundnbt = tileentity.func_189515_b(new CompoundNBT());
                    compoundnbt.func_82580_o("x");
                    compoundnbt.func_82580_o("y");
                    compoundnbt.func_82580_o("z");
                    list1.add(new Template.BlockInfo(blockpos4, blockstate, compoundnbt));
                    continue;
                }
                if (!blockstate.func_200015_d((IBlockReader)world, blockpos3) && !blockstate.func_224756_o((IBlockReader)world, blockpos3)) {
                    list2.add(new Template.BlockInfo(blockpos4, blockstate, (CompoundNBT)null));
                    continue;
                }
                list.add(new Template.BlockInfo(blockpos4, blockstate, (CompoundNBT)null));
            }
            ArrayList list3 = Lists.newArrayList();
            list3.addAll(list);
            list3.addAll(list1);
            list3.addAll(list2);
            ((ITemplateMixin)template).getBlocks().clear();
            ((ITemplateMixin)template).getBlocks().add(list3);
            ((ITemplateMixin)template).getEntities().clear();
        }
    }

    public static boolean isSurfaceFlat(ChunkGenerator<?> chunkGen, int chunkPosX, int chunkPosZ, int difference) {
        int offset = 16;
        int xStart = (chunkPosX << 4) + (7 - offset / 2);
        int zStart = (chunkPosZ << 4) + (7 - offset / 2);
        int i1 = chunkGen.func_222529_a(xStart, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int j1 = chunkGen.func_222529_a(xStart, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int k1 = chunkGen.func_222529_a(xStart + offset, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int l1 = chunkGen.func_222529_a(xStart + offset, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int minHeight = Math.min(Math.min(i1, j1), Math.min(k1, l1));
        int maxHeight = Math.max(Math.max(i1, j1), Math.max(k1, l1));
        return Math.abs(maxHeight - minHeight) <= difference;
    }

    @Nullable
    public static <T> T sendGET(String sendUrl, Class resultType) {
        Object result = null;
        try {
            URL url = new URL("https://pixelatedw.xyz/api/v1" + sendUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", APIConfig.projectId + "/" + APIConfig.projectVersion);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200 || responseCode == 202) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    sb.append(line + "\n");
                }
                in.close();
                result = new Gson().fromJson(sb.toString(), resultType);
            } else {
                System.out.println("==============ERROR WHILE RETRIEVING SERVER DATA==============");
                System.out.println("Response Code: " + responseCode + " - " + connection.getResponseMessage());
                System.out.println("=============================================================");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)result;
    }

    public static void removeAllModifiers(IAttributeInstance attr) {
        Set collection = attr.func_225505_c_();
        if (collection != null) {
            for (AttributeModifier attributemodifier : Lists.newArrayList((Iterable)collection)) {
                attr.func_111124_b(attributemodifier);
            }
        }
    }
}

